using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;
using System.IO;
using StatsTool.Properties;
using System.Drawing;
using System.Drawing.Imaging;
using System.Globalization;
using DdsFileType;
using StatsParse;

namespace StatsTool
{
	public class CDrawSession
	{
		private IList<CDrawRound> m_rounds = new List<CDrawRound>();
		private string m_name;
		private string m_mapName;

		#region Constructors

		public CDrawSession(CSessionRoot sessionData, string sessionName, SharedData sd)
		{
			m_name = sessionName;

			if (sessionData.m_mapName != null &&
					sessionData.m_roundData != null &&
					sessionData.m_teamData != null)
			{
				m_mapName = sessionData.m_mapName;

				int roundCnt = sessionData.m_roundData.Length;
				for (int rn = 0; rn < roundCnt; ++rn)
					m_rounds.Add( new CDrawRound(sessionData.m_roundData[rn], rn+1, sessionData.m_teamData, this, sd) );
			}					
		}

		public CDrawSession(CDrawRound[] rounds, string name, string mapName)
		{
			m_name = name;
			m_mapName = mapName;
			m_rounds = rounds;
		}

		#endregion

		public void DoDraw(Graphics g, SharedData data)
		{
			foreach (CDrawRound r in m_rounds)
				if (data.m_categoryFilters[EFilterType.ROUND].GetFlag(r.Name))
					r.DoDraw(g, data);
		}

		public void RequestRounds(UniqueList<string> res)
		{
			foreach (CDrawRound r in m_rounds)
				res.Add(r.Name);
		}

		public void RequestTeams(UniqueList<string> res)
		{
			foreach (CDrawRound r in m_rounds)
				r.RequestTeams(res);
		}

		public void RequestPlayers(UniqueList<string> res)
		{
			foreach (CDrawRound r in m_rounds)
				r.RequestPlayers(res);
		}

		public void RequestEventTypes(UniqueList<string> res, SharedData data)
		{
			foreach (CDrawRound r in Rounds)
				r.RequestEventTypes(res, data);
		}

		public string Name
		{
			get
			{
				return m_name;
			}
		}

		public string MapName
		{
			get
			{
				return m_mapName;
			}
		}

		public IList<CDrawRound> Rounds
		{
			get
			{
				return m_rounds;
			}
		}

	}
}

