using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;
using System.IO;
using StatsTool.Properties;
using System.Drawing;
using System.Drawing.Imaging;
using System.Globalization;
using DdsFileType;
using StatsParse;

namespace StatsTool
{
		public class CDrawTeam
    {
      private List<CDrawPlayer> m_players = new List<CDrawPlayer>();
			private int m_id;
			private CDrawRound m_parent;
			private const int AI_TEAM_ID = 0;

			private void AddActors(IActorLife[] lifes, bool playerControlled, int teamId, SharedData sd)
			{
				if (!playerControlled && teamId != AI_TEAM_ID)
					return;

				if (lifes != null)
				{
					int lifesCnt = lifes.Length;

					for (int lf = 0; lf < lifesCnt; ++lf)
						if (!playerControlled || lifes[lf].Team == teamId)
						{
							CDrawPlayer pla = new CDrawPlayer(lifes[lf], Color.White, sd, this, playerControlled);
							m_players.Add(pla);
						}
				}
			}

			public CDrawTeam(int id, CRoundData round, SharedData sd, CDrawRound parent)
      {
				m_id = id;
				m_parent = parent;

				AddActors(round.m_playerLifes, true, id, sd);
				AddActors(round.m_aiActorLifes, false, id, sd);
      }

			public IList<CDrawPlayer> Players
      {
          get
          {
              return m_players;
          }
      }

      public int Id
      {
          get
          {
              return m_id;
          }
      }

			public string Name
			{
				get
				{
					return GetTeamName(m_id);
				}
			}

			public CDrawRound Parent
			{
				get
				{
					return m_parent;
				}
			}

			public void DoDraw(Graphics g, Color color, SharedData data)
      {
        foreach (CDrawPlayer pl in Players)
					if (data.m_categoryFilters[EFilterType.PLAYER].GetFlag(pl.Name))
						if ( (data.m_showHumanControlled && pl.HumanControlled) || (data.m_showAiControlled && pl.AiControlled) )
							pl.DoDraw(g, color, data);
      }

			public void RequestPlayers(UniqueList<string> res)
			{
				foreach (CDrawPlayer pl in Players)
					res.Add(pl.Name);
			}

			public void RequestEventTypes(UniqueList<string> res, SharedData data)
			{
				foreach (CDrawPlayer pl in Players)
					pl.RequestEventTypes(res, data);
			}

			public static Color GetTeamColor(int id)
			{
				return Color.FromName((id == 1) ? Settings.Default.Team1Color : Settings.Default.Team2Color);
			}

			public static string GetTeamName(int id)
			{
				return (id==1) ? "Darkwater" : "Soulreaver";
			}
    }
}
