using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using StatsParse;
using StatsCharts;
using Excel = Microsoft.Office.Interop.Excel;

namespace StatsTool
{
	public class CExcelChartManager
	{
		private string m_xmlFileName, m_xlsFileName;
		private EChartKind m_chartKind;

		public CExcelChartManager(EChartKind chartKind, string appPath)
		{
			m_chartKind = chartKind;
			string curDir = Path.GetDirectoryName(appPath);
			string name = m_chartKind.ToString();

			m_xmlFileName = curDir + "/charts/" + name + "/build_stats_res.xml";
			m_xlsFileName = curDir + "/charts/" + name + "/view_stats.xls";
		}

		private void BuildExcelChartInput(Dictionary<string, CSessionRoot> sessions)
		{
			string[] fileNames = new string[1];
			SFiterData filter;
			filter.m_playerName = "0";
			string outFileName = m_xmlFileName;
			CStatsChartsManager.MakeChartXml(m_chartKind, sessions, filter, outFileName);
		}

		private void ShowExcelChart()
		{
			System.Globalization.CultureInfo oldCI = System.Threading.Thread.CurrentThread.CurrentCulture;
			System.Threading.Thread.CurrentThread.CurrentCulture = new System.Globalization.CultureInfo("en-US");

			try
			{
				Excel.ApplicationClass xapp = new Excel.ApplicationClass();
				xapp.Visible = true;
				xapp.UserControl = true;

				object oM = System.Reflection.Missing.Value;
				xapp.Workbooks.Open(m_xmlFileName, oM, oM, oM, oM, oM, oM, oM, oM, oM, oM, oM, oM, oM, oM);
				xapp.Workbooks.Open(m_xlsFileName, oM, oM, oM, oM, oM, oM, oM, oM, oM, oM, oM, oM, oM, oM);
			}
			catch (System.Exception e)
			{
				System.Windows.Forms.MessageBox.Show(e.Message, "Exception");
			}

			System.Threading.Thread.CurrentThread.CurrentCulture = oldCI;
		}

		public void MakeChart(Dictionary<string, CSessionRoot> sessions)
		{
			BuildExcelChartInput(sessions);
			ShowExcelChart();
		}
	}
}
