using NDensityAuto;
using System;
using System.Xml.Serialization;
using System.IO;
using System.Globalization;


namespace StatsTool
{
	using TRawDensityData = density_map;

	public static class CExtractDensity
	{
		public static void Do(string filename, CDensityData res)
		{
			XmlSerializer serializer = new XmlSerializer(typeof(TRawDensityData));
			using (FileStream stream = new FileStream(filename, FileMode.Open, FileAccess.Read))
			{
				TRawDensityData rawData = (TRawDensityData)serializer.Deserialize(stream);
				res.MakeFrom(rawData);
			}
		}
	}

	public class CDensityData : ICloneable
	{
		public string m_name;
		public string m_mapName;
		public string m_mapPath;

		public int m_cellSize;
		public int m_cellOffset;
		public long m_maxPointsInSq;
		public long[,] m_pointsInSq;

		public void MakeFrom(TRawDensityData val)
		{
			try
			{
				m_name = val.name;
				m_mapName = val.map;
				m_mapPath = val.map_path;
				if ( m_mapPath == null )
					m_mapPath = "";

				m_cellSize			=	Convert.ToInt32(val.@params[0].cell_size);
				m_maxPointsInSq	=	Convert.ToInt64(val.@params[0].max_val);

				int rowCnt = Convert.ToInt32(val.@params[0].row_count);
				int colCnt = Convert.ToInt32(val.@params[0].column_count);

				m_pointsInSq = new long[rowCnt, colCnt];

				for (int r = 0; r < rowCnt; ++r)
					for (int c = 0; c < colCnt; ++c)
						m_pointsInSq[r, c] = Convert.ToInt64(val.cells[0].row[r].col[c].val);
			}
			catch (System.FormatException)
			{
				System.Windows.Forms.MessageBox.Show("Invalid typecast in CDensityData.MakeFrom");
				return;
			}
		}

		public object Clone()
		{
			return this.MemberwiseClone();
		}
	};

}