using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using StatsTool.Dialogs;
using System.Drawing.Imaging;
using StatsTool.Properties;
using Microsoft.VisualBasic.Devices;
using System.IO;
using StatsParse;
using StatsCharts;

namespace StatsTool
{
	public partial class MainFrm : Form
	{
		public SharedData m_sharedData = new SharedData();
		private MiniMapForm m_miniMapDlg;
		private CDoubleTrackBar m_dtbTimeFilter;

		public MainFrm()
		{
			m_miniMapDlg = new MiniMapForm(m_sharedData);

			InitializeComponent();

			rbPathsLines.Checked		=	Settings.Default.PathsDrawMode == 0;
			rbPathsDensity.Checked	=	Settings.Default.PathsDrawMode == 1;
			rbPathsOff.Checked			= Settings.Default.PathsDrawMode == 2;

			rbEventsMarkers.Checked = Settings.Default.EventsDrawMode == 0;
			rbEventsDensity.Checked = Settings.Default.EventsDrawMode == 1;
			rbEventsOff.Checked			= Settings.Default.EventsDrawMode == 2;

			m_miniMapDlg.Visible = false;
		}

		private void openToolStripMenuItem_Click(object sender, EventArgs e)
		{
			fbd.SelectedPath = Settings.Default.LastPath;
			if (fbd.ShowDialog() == DialogResult.OK)
			{
				m_sharedData.m_fileLoadCompleted = false;
				m_sharedData.m_inputMode = EInputMode.SESSION;

				m_sharedData.m_sessions.Clear();
				
				Settings.Default.LastPath = fbd.SelectedPath;
				Settings.Default.Save();

				string[] sessionFiles = Directory.GetFiles(fbd.SelectedPath, "Game*.xml", SearchOption.TopDirectoryOnly);
				foreach (string file in sessionFiles)
				{
					CSessionRoot root = new CSessionRoot();
					CExtractSession.Do(file, root);

					m_sharedData.RegisterMapPath( root.m_mapName, root.m_mapPath );
					m_miniMapDlg.m_miniMapManager = new CMiniMapMan(root.m_mapName, root.m_mapPath, Path.GetDirectoryName(Application.ExecutablePath), m_sharedData);

					if (m_miniMapDlg.m_miniMapManager.MiniMap != null)
						m_sharedData.m_sessions.Add(Path.GetFileNameWithoutExtension(file), root);
				}

				m_miniMapDlg.Init(m_sharedData.m_sessions);
				m_sharedData.m_pathFilterFlags = new PathFilterFlags( cbOutdoor.Checked, cbIndoor.Checked, cbSpecialOnly.Checked );
				m_sharedData.m_singleEventIdx = -1;

				m_sharedData.m_densityThrFilterOn	= cbDensityFilterOn.Checked;
				m_sharedData.m_densityThrFrom = (long)nudDensityThrFrom.Value;
				m_sharedData.m_densityThrTo		= (long)nudDensityThrTo.Value;

				m_sharedData.m_densitySqSize	= (int)nudDensitySqSize.Value;
				m_sharedData.m_densitySqGap		= (int)nudDensitySqGap.Value;

				m_sharedData.m_showHumanControlled	= cbHumanControlled.Checked;
				m_sharedData.m_showAiControlled			=	cbAiControlled.Checked;
				m_sharedData.m_ignoreNoPosition			= false;

				InitFilterControls();
				ResetPositionsOfWindows();

				m_sharedData.m_fileLoadCompleted = true;
				m_miniMapDlg.UpdateOutput();
			}
		}

		private void openDensityMapToolStripMenuItem_Click(object sender, EventArgs e)
		{
			fbd.SelectedPath = Settings.Default.LastPath;
			if (fbd.ShowDialog() == DialogResult.OK)
			{
				m_sharedData.m_inputMode = EInputMode.DENSITY;

				m_sharedData.m_densities.Clear();

				Settings.Default.LastPath = fbd.SelectedPath;
				Settings.Default.Save();

				string[] densityFiles = Directory.GetFiles(fbd.SelectedPath, "Density*.xml", SearchOption.TopDirectoryOnly);
				foreach (string file in densityFiles)
				{
					CDensityData data = new CDensityData();
					CExtractDensity.Do(file, data);

					m_miniMapDlg.m_miniMapManager = new CMiniMapMan(data.m_mapName, data.m_mapPath, Path.GetDirectoryName(Application.ExecutablePath), m_sharedData);

					if (m_miniMapDlg.m_miniMapManager.MiniMap != null)
						m_sharedData.m_densities.Add(Path.GetFileNameWithoutExtension(file), data);
				}
			}

			m_miniMapDlg.UpdateOutput();
		}

		private void exitToolStripMenuItem_Click(object sender, EventArgs e)
		{
			Application.Exit();
		}

		private void optionsToolStripMenuItem_Click(object sender, EventArgs e)
		{
			Options optFrm = new Options();
			if (optFrm.ShowDialog(this) == DialogResult.OK)
			{
				m_miniMapDlg.UpdateOutput();
			}
		}

		private void InitFilterControls()
		{
			m_sharedData.m_filterLboxes.Clear();
			m_sharedData.m_filterLboxes.Add(EFilterType.MAP,					lbMap);
			m_sharedData.m_filterLboxes.Add(EFilterType.SESSION,			lbSession);
			m_sharedData.m_filterLboxes.Add(EFilterType.ROUND,				lbRound);
			m_sharedData.m_filterLboxes.Add(EFilterType.TEAM,					lbTeam);
			m_sharedData.m_filterLboxes.Add(EFilterType.PLAYER,				lbPlayer);
			m_sharedData.m_filterLboxes.Add(EFilterType.EVENT_GROUP,	lbEventGroup);
			m_sharedData.m_filterLboxes.Add(EFilterType.EVENT,				lbEvents);

			m_sharedData.m_catFilterFns.Clear();
			m_sharedData.m_catFilterFns.Add(EFilterType.MAP,					m_sharedData.m_drawMan.RequestMaps);
			m_sharedData.m_catFilterFns.Add(EFilterType.SESSION,			m_sharedData.m_drawMan.RequestSessions);
			m_sharedData.m_catFilterFns.Add(EFilterType.ROUND,				m_sharedData.m_drawMan.RequestRounds);
			m_sharedData.m_catFilterFns.Add(EFilterType.TEAM,					m_sharedData.m_drawMan.RequestTeams);
			m_sharedData.m_catFilterFns.Add(EFilterType.PLAYER,				m_sharedData.m_drawMan.RequestPlayers);
			m_sharedData.m_catFilterFns.Add(EFilterType.EVENT_GROUP,	m_sharedData.m_drawMan.RequestEventGroups);
			m_sharedData.m_catFilterFns.Add(EFilterType.EVENT,				m_sharedData.m_drawMan.RequestEventTypes);

			foreach (EFilterType type in Enum.GetValues(typeof(EFilterType)))
				FillLbFilter(type, type == EFilterType.MAP);

			m_dtbTimeFilter = new CDoubleTrackBar(tbrBegin, tbrEnd, tbxBegin, tbxEnd, tbxLongest, cbPreserve, m_sharedData, m_miniMapDlg.UpdateOutput);
		}

		private void FillSingleEventLboxes()
		{
			if (!m_sharedData.FiltersInited())
				return;

			lbEventSelection.Items.Clear();

			IEvent[] notHidenEvents = m_sharedData.m_drawMan.GetNotHidenEvents();

			if (notHidenEvents.Length == 0)
				return;

			foreach (IEvent ev in notHidenEvents)
				lbEventSelection.Items.Add(ev.Type);

			m_sharedData.m_notHidenEvents = notHidenEvents;

			lbEventSelection.SelectedIndex = 0;
			lbEventSelection.TopIndex = 0;
		}

		string MakeCheckAllStr(EFilterType category)
		{	
			return "< All " + EnumToHumanReadable(category) + "s >";
		}

		private void FillLbFilter(EFilterType type, bool noAll)
		{
			ListBox lb = m_sharedData.m_filterLboxes[type];
			RequestFilterCategoriesFn reqFn = m_sharedData.m_catFilterFns[type];

			lb.Items.Clear();
			UniqueList<string> categories = reqFn(m_sharedData);
			categories.Data.Sort();

			if (!noAll)
				categories.Data.Insert(SharedData.CheckAllIdx, MakeCheckAllStr(type));

			foreach (string s in categories.Data)
				lb.Items.Add(s);

			CategoryFilter catFilter = new CategoryFilter();
			catFilter.Init(categories.Data);
			m_sharedData.m_categoryFilters[type] = catFilter;

			if (noAll)
			{
				if ( lb.Items.Count > 0 )
					lb.SetSelected(0, true);
			}
			else
			{
				lb.SetSelected(SharedData.CheckAllIdx, true);
			}
			
			lb.TopIndex = 0;
		}

		private void pictureBox1_MouseClick(object sender, MouseEventArgs e)
		{
			m_miniMapDlg.UpdateOutput();
		}

		private CDrawSession[] MakeSingleSessionArray(CDrawSession ssn) 
		{
			CDrawSession[] sessions = new CDrawSession[1];
			sessions[0] = ssn;
			return sessions;
		}

		private CDrawRound[] MakeSingleRoundArray(CDrawRound rnd)
		{
			CDrawRound[] rounds = new CDrawRound[1];
			rounds[0] = rnd;
			return rounds;
		}

		private void FillEventFieldsCb(ComboBox cb, IEvent ev)
		{
			ITimelineValue tlVal = ev.TimelineValue;

			cb.Items.Clear();
			cb.SelectedItem = "";
			IList<string> fldNames = tlVal.GetFieldNames();
			foreach (string fn in fldNames)
				cb.Items.Add(fn);
			
			if (cb.Items.Count > 0)
				cb.SelectedIndex = 0;
		}

		private void toggleZoomToolStripMenuItem_Click(object sender, EventArgs e)
		{
			m_miniMapDlg.OnZoom();
		}

		private void rbPathsLines_CheckedChanged(object sender, EventArgs e)
		{
			if (rbPathsLines.Checked)
				Settings.Default.PathsDrawMode = 0;
			m_miniMapDlg.UpdateOutput();
		}

		private void rbPathsDensity_CheckedChanged(object sender, EventArgs e)
		{
			if (rbPathsDensity.Checked)
				Settings.Default.PathsDrawMode = 1;
			m_miniMapDlg.UpdateOutput();
		}

		private void rbPathsOff_CheckedChanged(object sender, EventArgs e)
		{
			if (rbPathsOff.Checked)
				Settings.Default.PathsDrawMode = 2;
			m_miniMapDlg.UpdateOutput();
		}

		private void rbEventsMarkers_CheckedChanged(object sender, EventArgs e)
		{
			if (rbEventsMarkers.Checked)
				Settings.Default.EventsDrawMode = 0;
			m_miniMapDlg.UpdateOutput();
		}

		private void rbEventsDensity_CheckedChanged(object sender, EventArgs e)
		{
			if (rbEventsDensity.Checked)
				Settings.Default.EventsDrawMode = 1;
			m_miniMapDlg.UpdateOutput();
		}

		private void rbEventsOff_CheckedChanged(object sender, EventArgs e)
		{
			if (rbEventsOff.Checked)
				Settings.Default.EventsDrawMode = 2;
			m_miniMapDlg.UpdateOutput();
		}

		private void cbOutdoor_CheckedChanged(object sender, EventArgs e)
		{
			m_sharedData.m_pathFilterFlags.Outdoor = cbOutdoor.Checked;
			m_miniMapDlg.UpdateOutput();
		}

		private void cbIndoor_CheckedChanged(object sender, EventArgs e)
		{
			m_sharedData.m_pathFilterFlags.Indoor = cbIndoor.Checked;
			m_miniMapDlg.UpdateOutput();
		}

		private void cbSpecialOnly_CheckedChanged(object sender, EventArgs e)
		{
			m_sharedData.m_pathFilterFlags.SpecialMovesOnly = cbSpecialOnly.Checked;
			m_miniMapDlg.UpdateOutput();
		}

		private void OnFilterCheck(EFilterType type)
		{
			CategoryFilter filter = m_sharedData.m_categoryFilters[type];
			ListBox lbox = m_sharedData.m_filterLboxes[type];

			int allIdx = lbox.Items.IndexOf(MakeCheckAllStr(type));
			if (allIdx > -1 && allIdx == SharedData.CheckAllIdx)
			{
				bool changing = false;

				bool selectAll = lbox.GetSelected(allIdx);

				Keyboard kbd = new Keyboard();
				if (selectAll && kbd.CtrlKeyDown)
				{
					selectAll = false;
					lbox.SetSelected(allIdx, false);
				}

				if (selectAll)
				{
					changing = filter.SetAllAndReportChanges(true);

					for (int i = 0; i < lbox.Items.Count; ++i)
						if (!lbox.GetSelected(i))
							lbox.SetSelected(i, true);

					lbox.TopIndex = 0;
				}
				else
				{					
					for (int i = 0; i < lbox.Items.Count; ++i)
						changing|= filter.SetIfChangingState(i, lbox.GetSelected(i));
				}

				if (changing)
					m_miniMapDlg.UpdateOutput();
			}
			else
			{
				System.Windows.Forms.MessageBox.Show("All-changing checker not first item in listbox! (" + type.ToString() + ") Incorrect! (look CheckAllIdx)");
			}
		}

		private void lbMap_SelectedIndexChanged(object sender, EventArgs e)
		{
			int idx = lbMap.SelectedIndex;
			string mapName = lbMap.Items[ idx ] as string;
			string mapPath = m_sharedData.GetMapPath(mapName);
			m_miniMapDlg.m_miniMapManager = new CMiniMapMan(mapName, mapPath, Path.GetDirectoryName(Application.ExecutablePath), m_sharedData);

			CategoryFilter filter = m_sharedData.m_categoryFilters[EFilterType.MAP];
			filter.SetAllFlags(false);
			filter.SetFlag(idx, true);

			m_miniMapDlg.UpdateOutput();
		}

		private void lbSession_SelectedIndexChanged(object sender, EventArgs e)
		{
			OnFilterCheck(EFilterType.SESSION);
		}

		private void lbRound_SelectedIndexChanged(object sender, EventArgs e)
		{
			OnFilterCheck(EFilterType.ROUND);
		}

		private void lbTeam_SelectedIndexChanged(object sender, EventArgs e)
		{
			OnFilterCheck(EFilterType.TEAM);
		}

		private void lbPlayer_SelectedIndexChanged(object sender, EventArgs e)
		{
			OnFilterCheck(EFilterType.PLAYER);
		}

		private void lbEventGroup_SelectedIndexChanged(object sender, EventArgs e)
		{ 
			OnFilterCheck(EFilterType.EVENT_GROUP);
			
			m_sharedData.m_eventGroups.Clear();
			for (int i = 0; i < lbEventGroup.Items.Count; ++i)
				m_sharedData.m_eventGroups.Add((EEventGroup)i, lbEventGroup.GetSelected(i));

			FillLbFilter(EFilterType.EVENT, false);
		}

		private void lbEvents_SelectedIndexChanged(object sender, EventArgs e)
		{
			m_sharedData.m_attributeFilterData.m_ignore = true;
			const EFilterType flType = EFilterType.EVENT;
			OnFilterCheck(flType);

			cbUseTargetPosition.Checked = false;
			bool useTargetCbEnabled = false;

			ListBox lbox = m_sharedData.m_filterLboxes[flType];
			int selCnt = lbox.SelectedItems.Count;

			if ( selCnt == 1 )
			{
				IEvent[] notHidenEvents = m_sharedData.m_drawMan.GetNotHidenEvents();
				if (notHidenEvents.Length > 0)
				{
					IEvent sampleEv = notHidenEvents[0];
					FillEventFieldsCb( cbAttribute, sampleEv);
					Dictionary<string, object> fldMap = sampleEv.TimelineValue.GetFieldMap();
					useTargetCbEnabled = fldMap.ContainsKey( CEvent.TARGET_ID_FIELD_NAME );
				}

				if (cbAttribute.Items.Count > 0)
					cbAttribute.SelectedIndex = 0;
			}
			else
			{
				ClearAttributeFilter();
			}

			cbUseTargetPosition.Enabled = useTargetCbEnabled;
		}

		private void ClearAttributeFilter()
		{
			ClearComboBox(cbAttribute);
			ClearComboBox(cbComparsionType);
			ClearComboBox(cbEtalon);
		}

		private void ClearComboBox( ComboBox cb )
		{
			cb.Items.Clear();
			cb.Text = "";
			cb.SelectedIndex = -1;
			cb.Tag = null;
		}

		private void ResetPositionsOfWindows()
		{
			this.SetDesktopLocation(0, 0);
			m_miniMapDlg.SetDesktopBounds(this.Size.Width, 0, this.Size.Height - 10, this.Size.Height);
		}

		private IEvent GetSelectedSingleEvent()
		{
			IEvent[] events = m_sharedData.m_notHidenEvents;
			if (events == null)
				return null;

			int selIdx = lbEventSelection.SelectedIndex;
			if (selIdx < 0)
				return null;

			return events[selIdx];
		}

		private void btnResetPositions_Click(object sender, EventArgs e)
		{
			ResetPositionsOfWindows();
		}

		private void UpdateSelectedPanel()
		{
			if (tcMain.SelectedIndex == 2)//charts
			{
				m_miniMapDlg.Visible = false;
				if (cbChart.Items.Count == 0)
					foreach (EChartKind ck in Enum.GetValues(typeof(EChartKind)))
						cbChart.Items.Add(ck.ToString().Replace('_', ' '));
			}
			else
			{
				bool singleES = tcMain.SelectedIndex == 1;
				if (singleES)
				{
					FillSingleEventLboxes();
					FillDependentEventControls();
				}

				m_sharedData.m_singleEventIdx = singleES ? lbEventSelection.SelectedIndex : -1;
				m_miniMapDlg.UpdateOutput();
			}
		}

		private void tcMain_SelectedIndexChanged(object sender, EventArgs e)
		{
			UpdateSelectedPanel();
		}

		private void lbEventSelection_SelectedIndexChanged(object sender, EventArgs e)
		{
			IEvent ev = GetSelectedSingleEvent();
			if ( ev == null )
				return;

			lbEventFields.Items.Clear();

			foreach (string str in ev.Fields)
				lbEventFields.Items.Add(str);

			m_sharedData.m_singleEventIdx = lbEventSelection.SelectedIndex;

			FillEventFieldsCb(cbDependentEventField, ev);
			cbDependentEventKind.Items.Clear();
			cbDependentEventKind.SelectedItem = "";

			m_miniMapDlg.UpdateOutput();
		}

		private void cbAttribute_SelectedIndexChanged(object sender, EventArgs e)
		{
			if ( cbAttribute.SelectedIndex == -1 )
				return;

			cbEtalon.SelectedIndex = -1;
			cbEtalon.Items.Clear();
			cbEtalon.Tag = null;
			cbEtalon.Text = SharedData.AnyValueStr;

			IEvent[] notHidenEvents = m_sharedData.m_drawMan.GetNotHidenEvents();
			if (notHidenEvents.Length > 0)
			{
				string attr = cbAttribute.Text;
				UniqueList<object> values = new UniqueList<object>();

				foreach (IEvent ev in notHidenEvents)
				{
					ITimelineValue tlVal = ev.TimelineValue;
					Dictionary<string, object> fldMap = tlVal.GetFieldMap();

					if (fldMap.ContainsKey(attr))
						values.Add(fldMap[attr]);
				}

				if (values.Data.Count > 0)
				{
					Type valType = values.Data[0].GetType(); 
					cbEtalon.Tag = valType;

					cbEtalon.Items.Add(SharedData.AnyValueStr);
					
					values.Data.Sort();
					foreach (object obj in values.Data)
						cbEtalon.Items.Add(obj.ToString());

					cbComparsionType.Items.Clear();
					EComparsionType[] enumArr;
					if ( valType != typeof(string) && valType.GetInterface("IComparable") != null )
					{
						Array valArr = Enum.GetValues(typeof(EComparsionType));
						int valLen = valArr.Length;
						enumArr = new EComparsionType[valLen];
						Array.Copy(valArr, enumArr, valLen);
					}
					else
					{
						enumArr = new EComparsionType[2];
						enumArr.SetValue( EComparsionType.Equal_to, 0 );
						enumArr.SetValue(	EComparsionType.Not_equal_to, 1);
					}

					foreach ( EComparsionType ct in enumArr )
						cbComparsionType.Items.Add( EnumToHumanReadable(ct) );
				}
			}
			if (cbComparsionType.Items.Count > 0)
				cbComparsionType.SelectedIndex = 0;
		}

		private void FillAttributeFilterData()
		{
			string attr = cbAttribute.Text;
			int cmpIdx = cbComparsionType.SelectedIndex;

			if (cmpIdx == -1)
				return;

			if (cbEtalon.Text.Length == 0)
				return;

			if (cbEtalon.Tag == null)
				return;
			
			Type tp = cbEtalon.Tag as Type;

			if (cbEtalon.Text == SharedData.AnyValueStr)
			{
				m_sharedData.m_attributeFilterData.m_ignore = true;
			}
			else
			{
				m_sharedData.m_attributeFilterData.m_ignore = false;
				m_sharedData.m_attributeFilterData.m_fieldName = attr;
				m_sharedData.m_attributeFilterData.m_comparsionType = (EComparsionType)cmpIdx;

				if (tp != typeof(string))
				{
					m_sharedData.m_attributeFilterData.m_etalon = Activator.CreateInstance(tp);

					System.Reflection.MethodInfo parse = tp.GetMethod("Parse", new Type[] { typeof(string) });
					if (parse != null)
					{
						try
						{
							m_sharedData.m_attributeFilterData.m_etalon = parse.Invoke(m_sharedData.m_attributeFilterData.m_etalon, new object[] { cbEtalon.Text });
						}
						catch (System.Exception ex)
						{
							string msg = ex.Message;
						}
					}
				}
				else
				{
					m_sharedData.m_attributeFilterData.m_etalon = cbEtalon.Text;
				}
			}
		
			m_miniMapDlg.UpdateOutput();
		}

		private void cbEtalon_SelectedIndexChanged(object sender, EventArgs e)
		{
			FillAttributeFilterData();
		}

		private void cbEtalon_KeyUp(object sender, KeyEventArgs e)
		{
			//if (e.KeyCode == Keys.Enter)
				FillAttributeFilterData();
		}

		private void cbComparsionType_SelectedIndexChanged(object sender, EventArgs e)
		{
			FillAttributeFilterData();
		}

		private void MainFrm_Resize(object sender, EventArgs e)
		{
			m_miniMapDlg.Visible = this.WindowState != FormWindowState.Minimized;
		}

		private void tbrBegin_ValueChanged(object sender, EventArgs e)
		{
			if (m_dtbTimeFilter != null)
				m_dtbTimeFilter.OnTbrBeginValueChanged();
		}

		private void tbrEnd_ValueChanged(object sender, EventArgs e)
		{
			if (m_dtbTimeFilter != null)
				m_dtbTimeFilter.OnTbrEndValueChanged();
		}

		private void tbxBegin_KeyUp(object sender, KeyEventArgs e)
		{
			if (m_dtbTimeFilter != null)
				m_dtbTimeFilter.OnTbxBeginEnterPressed(e);
		}

		private void tbxEnd_KeyUp(object sender, KeyEventArgs e)
		{
			if (m_dtbTimeFilter != null)
				m_dtbTimeFilter.OnTbxEndEnterPressed(e);
		}

		private void btChart_Click(object sender, EventArgs e)
		{
			if (cbChart.SelectedIndex == -1)
				return;

			if (m_sharedData.m_sessions.Count == 0)
				return;

			EChartKind chartKind = (EChartKind)cbChart.SelectedIndex;
			CExcelChartManager chartMgr = new CExcelChartManager(chartKind, Application.ExecutablePath);
			chartMgr.MakeChart(m_sharedData.m_sessions);
		}

		private void cbUseTargetPosition_CheckedChanged(object sender, EventArgs e)
		{
			m_sharedData.m_useTargetPos = cbUseTargetPosition.Enabled && cbUseTargetPosition.Checked;
			m_miniMapDlg.UpdateOutput();
		}

		private void cbDependentEventField_SelectedIndexChanged(object sender, EventArgs e)
		{
			FillDependentEventControls();
		}

		private void FillDependentEventControls()
		{
			if ( lbEventSelection.SelectedItem == null || cbDependentEventField.SelectedItem == null )
				return;

			string sourceEventName = lbEventSelection.SelectedItem.ToString();
			string targetFieldName = cbDependentEventField.SelectedItem.ToString();
			if ( sourceEventName.Length == 0 || targetFieldName.Length == 0 )
				return;

			Dictionary<string, bool> eventNames = new Dictionary<string, bool>();
			eventNames[sourceEventName] = false;//except source event type

			foreach ( KeyValuePair<string, CSessionRoot> snKvp in m_sharedData.m_sessions )
		  {
		    if (snKvp.Value.m_roundData == null)
		      continue;

		    foreach (CRoundData rd in snKvp.Value.m_roundData)
		    {
		      if (rd.m_playerLifes == null)
		        continue;

		      foreach ( CPlayerLife pl in rd.m_playerLifes )
						foreach ( KeyValuePair<string, ITimelineValue[]> tvKvp in pl.EventTimelines )
							if ( tvKvp.Value.Length > 0 )
								if ( !eventNames.ContainsKey( tvKvp.Key ) )								
								{
									ITimelineValue tv = tvKvp.Value[0];
									Dictionary<string, object> fm = tv.GetFieldMap();
									eventNames[tvKvp.Key] = fm.ContainsKey( targetFieldName );
								}
				}
			}

			cbDependentEventKind.SelectedText = "";
			cbDependentEventKind.SelectedItem = null;
			cbDependentEventKind.Items.Clear();
			foreach( KeyValuePair<string, bool> kvp in eventNames )
				if ( kvp.Value )
					cbDependentEventKind.Items.Add( kvp.Key );

			if ( cbDependentEventKind.Items.Count > 0 )
				cbDependentEventKind.SelectedIndex = 0;//will set SelectedItem to not null value
		}

		public static string EnumToHumanReadable(object enumVal)
		{
			return enumVal.ToString().Replace('_', ' ').ToLower();
		}

		private void btnFilterDependent_Click(object sender, EventArgs e)
		{
			if ( cbDependentEventField.SelectedItem == null || cbDependentEventKind.SelectedItem == null )
				return;

			string targetFieldName = cbDependentEventField.SelectedItem.ToString();
			string targetEventName = cbDependentEventKind.SelectedItem.ToString();
			if ( targetFieldName.Length == 0 || targetEventName.Length == 0 )
				return;

			IEvent ev = GetSelectedSingleEvent();
			if ( ev == null )
				return;

			Dictionary<string, object> fm = ev.TimelineValue.GetFieldMap();
			System.Diagnostics.Debug.Assert( fm.ContainsKey( targetFieldName ) );
			object valueToFilter = fm[targetFieldName];

			int idxBackup = m_sharedData.m_singleEventIdx;
			m_sharedData.m_singleEventIdx = -1;//single event mode off

			lbEvents.SelectedItems.Clear();
			lbEvents.SelectedItem					= targetEventName;
			cbAttribute.SelectedItem			= targetFieldName;
			cbComparsionType.SelectedItem	= EnumToHumanReadable(EComparsionType.Equal_to);
			cbEtalon.SelectedItem					= valueToFilter.ToString();

			m_sharedData.m_singleEventIdx = idxBackup;//single event mode restored

			cbDependentEventField.Items.Clear();
			cbDependentEventField.SelectedItem = "";

			cbDependentEventKind.Items.Clear();
			cbDependentEventKind.SelectedItem = "";

			UpdateSelectedPanel();
		}

		private void nudDensitySqSize_ValueChanged(object sender, EventArgs e)
		{
			m_sharedData.m_densitySqSize = (int)nudDensitySqSize.Value;
			nudDensitySqGap.Maximum = nudDensitySqSize.Value - 1;
			m_miniMapDlg.UpdateOutput();
		}

		private void nudDensitySqGap_ValueChanged(object sender, EventArgs e)
		{
			m_sharedData.m_densitySqGap = (int)nudDensitySqGap.Value;
			m_miniMapDlg.UpdateOutput();
		}

		private void nudDensityThrFrom_ValueChanged(object sender, EventArgs e)
		{
			m_sharedData.m_densityThrFrom = (long)nudDensityThrFrom.Value;
			nudDensityThrTo.Value = Math.Max( nudDensityThrTo.Value, nudDensityThrFrom.Value + 1 );
			m_miniMapDlg.UpdateOutput();
		}

		private void nudDensityThrTo_ValueChanged(object sender, EventArgs e)
		{
			m_sharedData.m_densityThrTo = (long)nudDensityThrTo.Value;
			nudDensityThrFrom.Value = Math.Min( nudDensityThrFrom.Value, nudDensityThrTo.Value - 1 );
			m_miniMapDlg.UpdateOutput();
		}

		private void cbFullDensityRange_CheckedChanged(object sender, EventArgs e)
		{
			bool b = cbDensityFilterOn.Checked;
			m_sharedData.m_densityThrFilterOn = b;
			nudDensityThrFrom.Enabled = b;
			nudDensityThrTo.Enabled		= b;
			m_miniMapDlg.UpdateOutput();
		}

		private void cbHumanControlled_CheckedChanged(object sender, EventArgs e)
		{
			m_sharedData.m_showHumanControlled = cbHumanControlled.Checked;
			m_miniMapDlg.UpdateOutput();
		}

		private void cbAiControlled_CheckedChanged(object sender, EventArgs e)
		{
			m_sharedData.m_showAiControlled = cbAiControlled.Checked;
			m_miniMapDlg.UpdateOutput();
		}
	}
}