using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using StatsParse;

namespace StatsTool
{
	public partial class MiniMapForm : Form
	{
		public SharedData m_sharedData;

		Bitmap m_image;
		public CMiniMapMan m_miniMapManager;

		public MiniMapForm(SharedData sd)
		{
			m_sharedData = sd;
			InitializeComponent();
		}

		public void Init(Dictionary<string, CSessionRoot> sessions)
		{
			m_sharedData.m_drawMan = new CDrawMan(sessions, m_sharedData);
		}

		private Image GetImage(Size sz)
		{
			if (m_image == null || m_image.Size.Width != sz.Width || m_image.Size.Height != sz.Height)
			{
				m_image = new Bitmap(sz.Width, sz.Height);
			}
			return m_image;
		}

		private Graphics MakeBackground()
		{
			this.pictureBox.Image = GetImage(m_miniMapManager.MiniMap.Size);
			Graphics g = Graphics.FromImage(this.pictureBox.Image);
			g.DrawImage(m_miniMapManager.MiniMap, new Point(0, 0));

			return g;
		}

		public void OnZoom()
		{
			//[sergiyy] Dock should be set before SizeMode,
			//or map will not work correctly if zoom was toggled
			//when top left corner of picture was not visible
			if (pictureBox.SizeMode == PictureBoxSizeMode.StretchImage)
			{
				pictureBox.Dock = DockStyle.None;
				pictureBox.SizeMode = PictureBoxSizeMode.AutoSize;
			}
			else
			{
				pictureBox.Dock = DockStyle.Fill;
				pictureBox.SizeMode = PictureBoxSizeMode.StretchImage;
			}
		}

		public void UpdateOutput()
		{
			if (m_sharedData.m_drawMan == null || m_sharedData.m_drawMan.SameMapSessions == null)
				return;

			if ( !m_sharedData.FiltersInited() || !m_sharedData.m_fileLoadCompleted )
				return;

			if (!this.Visible)
				this.Visible = true;

			switch (m_sharedData.m_inputMode)
			{
				case EInputMode.SESSION:
					{
						DrawSessionMap();
					} break;

				case EInputMode.DENSITY:
					{
						DrawDensityMap();
					} break;
			}
		}

		private void DrawSessionMap()
		{
			if (m_miniMapManager == null || m_sharedData.m_drawMan == null)
				return;

			if (m_miniMapManager.MiniMap == null)
			{
				pictureBox.Image = null;
				pictureBox.Invalidate();
				return;
			}

			Graphics g = MakeBackground();

			if ( CDrawDensity.IsDensityMode )
				CDrawDensity.Init(g, m_sharedData.m_densitySqSize, m_sharedData.m_densitySqGap );

			m_sharedData.m_drawMan.DoDraw(g, m_sharedData);

			if ( CDrawDensity.IsDensityMode )
				CDrawDensity.DoDraw( g, m_sharedData.m_densityThrFilterOn, m_sharedData.m_densityThrFrom, m_sharedData.m_densityThrTo );

			g.Dispose();
			pictureBox.Invalidate();
		}

		private void DrawDensityMap()
		{
			if (m_sharedData.m_density == null || m_miniMapManager == null)
				return;

			if (m_miniMapManager.MiniMap == null)
			{
				pictureBox.Image = null;
				pictureBox.Invalidate();
				return;
			}

			Graphics g = MakeBackground();			
			CDrawDensity.DensityData = m_sharedData.m_density;
			CDrawDensity.DoDraw( g, m_sharedData.m_densityThrFilterOn, m_sharedData.m_densityThrFrom, m_sharedData.m_densityThrTo );			

			g.Dispose();
			pictureBox.Invalidate();
		}

		private void pictureBox_MouseClick(object sender, MouseEventArgs e)
		{
			IEvent ev = m_sharedData.m_drawMan.GetEventFromPoint( new Vec2(e.Location.X, e.Location.Y) );
			if (ev != null)
			{
				ttEvent.ToolTipTitle = "Event: " + ev.Type;
				for (int i = 0; i < 2; ++i )//HACK: to make it displays correctly
					ttEvent.Show(ev.Desc, pictureBox, (int)ev.X, (int)ev.Y);
			}
			else
				ttEvent.Hide(pictureBox);
		}
	}
}