using System;
using System.Collections.Generic;
using System.Text;
using StatsParse;

namespace StatsTool
{
		public class CPlayerPos
    {
        private Vec3 m_pos;
        private float m_glevel;
        private float m_correction = 0.20f;
				private int m_time;
				private int m_originTime;

				public CPlayerPos(float x, float y, float z, float glevel, int time, int originTime, float correction)
        {
            m_pos					= new Vec3(x, y, z);
            m_glevel			= glevel;
						m_time				= time;
						m_originTime	= originTime;
            m_correction	= correction;
        }

				public CPlayerPos(float x, float y, float z, float m_glevel, int m_time, int originTime)
				: this(x, y, z, m_glevel, m_time, originTime, 0.20f) 
				{
				}

        public CPlayerPos()
				: this(0, 0, 0, 0, 0, 0)
				{
				}

        public float X
        {
            get { return m_pos.x; }
            set { m_pos.x = value; }
        }

        public float Y
        {
            get { return m_pos.y; }
            set { m_pos.y = value; }
        }

        public float Z
        {
            get { return m_pos.z; }
            set { m_pos.z = value; }
        }
				
				public Vec3 Pos
				{
					get { return m_pos; }
					set { m_pos = value; }
				}

				public Vec2 Pos2d
				{
					get { return new Vec2( m_pos.x, m_pos.y ); }
				}

        public bool Indoor
        {
            get { return Z + m_correction < m_glevel; }
        }

				public bool Outdoor
				{
					get { return !Indoor; }
				}
			
				public bool InSpecialMove(Dictionary<string, ITimelineValue[]> eventTlines)
				{
					foreach (KeyValuePair<string, ITimelineValue[]> kvp in eventTlines)
					{
						switch (kvp.Key)
						{
							case "climb_alone":
							case "climb_coop":
							case "climb_assist":
							case "push_solo":
							case "push_coop":
							case "tactical":
							case "haste":
							{
								ITimelineValue[] vals = kvp.Value;
								foreach (ITimelineValue val in vals)
									if (val.GetTime() >= m_time)
									{
										CPrmTimelineValue prmVal = val as CPrmTimelineValue;
										if (prmVal != null)
											if (prmVal.m_prm == "begin")
												return true;

										break;
									}

							} break;
						}
					}

					return false;
				}

				public int Time
				{
            get { return m_time; }
            set { m_time = value; }
        }

				public float GetTimeInSeconds()
				{
					return SharedData.GetTimeFromRoundStart(m_time, m_originTime);
				}
    }
}
