using System;
using System.Collections.Generic;
using System.Windows.Forms;
using StatsParse;

namespace StatsTool
{
	public enum EInputMode
	{
		SESSION,
		DENSITY
	}

	public enum EFilterType
	{
		MAP = 0,
		SESSION,
		ROUND,
		TEAM,
		PLAYER,
		EVENT_GROUP,
		EVENT
	}

	public enum EEventGroup
	{
		ALL = SharedData.CheckAllIdx,
		COMBAT,
		MOVEMENT,
		OTHER
	}

	public delegate UniqueList<string> RequestFilterCategoriesFn(SharedData data);

	public class CoordTransformData
	{
		private float m_StartX, m_StartY;
		private float m_AspectX, m_AspectY;

		public CoordTransformData( float startX, float startY, float aspectX, float aspectY )
		{
			this.m_StartX = startX;
			this.m_StartY = startY;
			this.m_AspectX = aspectX;
			this.m_AspectY = aspectY;
		}
		
		public void Transform(Vec3 vec)
		{
			vec.x = (vec.x - m_StartX) * m_AspectX;
			vec.y = (vec.y - m_StartY) * m_AspectY;
		}
	};

	public class SharedData
	{
		public CDrawMan m_drawMan;
		public Dictionary<string, CSessionRoot> m_sessions = new Dictionary<string, CSessionRoot>();

		public EInputMode m_inputMode = EInputMode.SESSION;
		
		public bool m_densityThrFilterOn;
		public long m_densityThrFrom, m_densityThrTo;
		
		public PathFilterFlags m_pathFilterFlags;
		public SAttributeFilterData m_attributeFilterData;
		public STimeFilterData m_timeFilterData;
		public bool m_useTargetPos;

		public CDensityData m_density;
		public Dictionary<string, CDensityData> m_densities = new Dictionary<string, CDensityData>();
		public bool m_fileLoadCompleted = false;

		public const int CheckAllIdx = 0;
		public const int AnyValueIdx = 0;
		public const string AnyValueStr = "< Any value >";

		public Dictionary<EFilterType, CategoryFilter> m_categoryFilters = new Dictionary<EFilterType, CategoryFilter>();
		public Dictionary<EFilterType, ListBox> m_filterLboxes = new Dictionary<EFilterType, ListBox>();
		public Dictionary<EFilterType, RequestFilterCategoriesFn> m_catFilterFns = new Dictionary<EFilterType, RequestFilterCategoriesFn>();

		public Dictionary<EEventGroup, bool> m_eventGroups = new  Dictionary<EEventGroup, bool>();

		public IEvent[] m_notHidenEvents;
		public int m_singleEventIdx;

		public Dictionary<string, CoordTransformData> m_coordTransformData = new Dictionary<string, CoordTransformData>();
		public string m_curMapName;

		public TimeSpan m_longestRoundTime = new TimeSpan(1);

		public int m_densitySqSize, m_densitySqGap;

		public bool m_showHumanControlled, m_showAiControlled;
		public bool m_ignoreNoPosition;

		private Dictionary<string, string> m_mapPaths = new Dictionary<string, string>();

		public bool FiltersInited()
		{
			int filterTypeCount = Enum.GetValues(typeof(EFilterType)).GetLength(0);
			return m_categoryFilters.Count == filterTypeCount;
		}

		static public float GetTimeFromRoundStart( int globalTime, int origin )//converts to seconds
		{
			bool good = origin <= globalTime;
			System.Diagnostics.Debug.Assert(good);
			if (!good)
				return 0.0f;

			globalTime -= origin;
			return globalTime / 1000.0f; 
		}

		public string GetMapPath( string mapName )
		{
			if ( m_mapPaths.ContainsKey( mapName ) )
				return m_mapPaths[ mapName ];
			
			return "";
		}

		public void RegisterMapPath( string mapName, string mapPath )
		{
			if ( mapName.Length > 0 && mapPath.Length > 0 )
				if ( !m_mapPaths.ContainsKey( mapName ) )
					m_mapPaths[ mapName ] = mapPath;
		}
	};
}