﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Storage;
using StatsDataSource.ObjectModel;
using System.Xml.Serialization;
using StatsDataSource.Filters;

namespace StatsTool2.Filters
{
	[Serializable]
	public class EventFilter : TerminalFilter
	{
		[XmlAttribute("operation")]
		public ECompareOperation m_op;

		[XmlAttribute("stat_name")]
		public string m_name;

		[XmlAttribute("param")]
		public string m_param;

		[XmlAttribute("value")]
		public string m_value;

		[XmlAttribute("match_name")]
		public bool m_matchName;

		[XmlAttribute("missing_fails")]
		public bool m_missingFails;

		public EventFilter()
		{
			Enabled = true;
		}

		public void Init(ECompareOperation op,
											string name,
											bool match_name,
											string param,
											bool missingFails,
											string value)
		{
			m_op = op;
			m_name = name;
			m_param = param;
			m_value = value;
			m_matchName = match_name;
			m_missingFails = missingFails;
		}

		public override object Clone()
		{
			var ret = new EventFilter();
			ret.Init(m_op, m_name, m_matchName, m_param, m_missingFails, m_value);
			ret.Enabled = Enabled;
			ret.Name = Name;
			return ret;
		}

		public override EFilterState TestEventGroup(GameEventGroup group)
		{
			if (!Enabled || string.IsNullOrEmpty(m_name))
				return EFilterState.Unaffected;

			if (m_name == group.Desc.Name)
				return EFilterState.Passed;

			return m_matchName ? EFilterState.Failed : EFilterState.Unaffected;
		}

		public override EFilterState TestEvent(GameEvent evnt)
		{
			if (!Enabled || (m_op == ECompareOperation.Unknown && !m_missingFails))
				return EFilterState.Unaffected;

			string value;

			if (evnt.Parameters.TryGetValue(m_param, out value))
			{
				if (m_op == ECompareOperation.Unknown)
					return EFilterState.Passed;

				return FilterManager.CompareValuesRelative(value, m_value, m_op)
					? EFilterState.Passed
					: EFilterState.Failed;
			}

			return m_missingFails ? EFilterState.Failed : EFilterState.Unaffected;
		}
	}
}
