﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Storage;
using StatsDataSource.ObjectModel;
using StatsDataSource.Filters;

namespace StatsTool2.Filters
{
	class EventTimeFilter : TerminalFilter
	{
		public Int64 MinTime { get; set; }
		public Int64 MaxTime { get; set; }

		public EventTimeFilter()
		{
			Enabled = true;
			MinTime = Int64.MinValue;
			MaxTime = Int64.MaxValue;
		}

		public override object Clone()
		{
			throw new NotImplementedException();
		}

		public override EFilterState TestEvent(GameEvent evnt)
		{
			if (!Enabled) return EFilterState.Unaffected;
			return (evnt.TimeMillisecs >= MinTime && evnt.TimeMillisecs <= MaxTime) ? EFilterState.Passed : EFilterState.Failed;
		}
	}
}
