﻿using System;
using System.Collections.Generic;
using System.Text;
using StatsDataSource.Storage;
using System.Xml;
using System.Xml.Serialization;
using System.Diagnostics;
using StatsDataSource.Filters;

namespace StatsTool2.Filters
{
	//////////////////////////////////////////////////////////////////

	public enum EAffectedType
	{
		Scope,
		Element,
		Node,
		Event,

		Unknown,
	}

	//////////////////////////////////////////////////////////////////


	class FilterManager
	{
		//////////////////////////////////////////////////////////////////

		public StatsRepository Repository { get; private set; }

		public EventTimeFilter EventTimeFilter { get; private set; }

		public CompoundFilter RootFilter { get; private set; }

		//////////////////////////////////////////////////////////////////

		public FilterManager(StatsRepository repo)
		{
			Repository = repo;

			EventTimeFilter = new EventTimeFilter();
			RootFilter = new CompoundANDFilter() { Tag = "MAIN_FORM_ROOT_FILTER" };
			RootFilter.AddChild(EventTimeFilter);

			Repository.AddSubFilter(RootFilter);
		}

		//////////////////////////////////////////////////////////////////

		static internal bool CompareValuesRelative(string lhs, string rhs, ECompareOperation op)
		{
			int val = FilterManager.ComapreValues(lhs, rhs);
			switch (op)
			{
				case ECompareOperation.Equal:					return val == 0;
				case ECompareOperation.NotEqual:			return val != 0;
				case ECompareOperation.Less:					return val <  0;
				case ECompareOperation.LessEqual:			return val <= 0;
				case ECompareOperation.Greater:				return val >  0;
				case ECompareOperation.GreaterEqual:	return val >= 0;
				default:
					throw new NotImplementedException();
			}
		}

		static internal int ComapreValues(string lhs, string rhs)
		{
			float fRhs, fLhs;
			if (float.TryParse(rhs, out fRhs) && float.TryParse(lhs, out fLhs))
				return (fLhs < fRhs) ? -1 : ((fLhs > fRhs) ? 1 : 0);

			return string.Compare(lhs, rhs);
		}

		//////////////////////////////////////////////////////////////////////////
	}
}
