﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using StatsDataSource.Storage;
using StatsTool2.Filters;
using StatsDataSource.Core;
using System.Reflection;
using System.IO;

namespace StatsTool2
{
	static class Program
	{
		public static string[] CmdArgs { get; set; }
		public static string Location { get; set; }
		public static MainForm MainForm { get; set; }
		public static StatsRepository StatsRepository { get; set; }
		public static StatsCore StatsCore { get; set; }
		public static FilterManager FilterManager { get; set; }

		[STAThread]
		static void Main(string[] args)
		{
			CmdArgs = args;
			Location = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
			Application.Run(new MainForm());
		}
	}
}
