#pragma once

namespace CryUnitWrapper 
{
    class CTestListenerWrapper;

	[System::Serializable]
    public ref class CallStackElement
    {
    public:
        CallStackElement(System::String^ functionName, System::String^ moduleName, System::String^ fileName, int fileLineNumber);

        property System::String^ FunctionName
        {
            System::String^ get() 
            { 
                return m_functionName;
            }
        }

        property System::String^ ModuleName
        {
            System::String^ get() 
            { 
                return m_moduleName;
            }
        }

        property System::String^ FileName
        {
            System::String^ get() 
            { 
                return m_fileName;
            }
        }

        property int FileLineNumber
        {
            int get() 
            { 
                return m_fileLineNumber;
            }
        }
    private:
        System::String^ m_functionName;
        System::String^ m_moduleName;
        System::String^ m_fileName;
        int m_fileLineNumber;
    };

	[System::Serializable]
    public ref class FailureInfo
    {
    public:
        FailureInfo(System::String^ condition, System::String^ message, System::String^ fileName, int fileLineNumber, array<CallStackElement^>^ callStack);

        property System::String^ Condition
        {
            System::String^ get() 
            { 
                return m_condition;
            }
        }

        property System::String^ Message
        {
            System::String^ get() 
            { 
                return m_message;
            }
        }

        property System::String^ FileName
        {
            System::String^ get() 
            { 
                return m_fileName;
            }
        }

        property array<CallStackElement^>^ CallStack
        {
            array<CallStackElement^>^ get() 
            { 
                return m_callStack;
            }
        }

        property int FileLineNumber
        {
            int get() 
            { 
                return m_fileLineNumber;
            }
        }

    private:
        System::String^ m_condition;
        System::String^ m_message;
        System::String^ m_fileName;
        int m_fileLineNumber;
        array<CallStackElement^>^ m_callStack;
    };
}
