#include "stdafx.h"
#include "TestRunInfo.h"
#include "FailureInfo.h"

#include <CryUnitInterfaces.h>

using System::String;

namespace CryUnitWrapper 
{
	namespace Marshall 
	{
		TestRunInfo^ CreateTestRunInfo(const CryUnit::STestInfo& testInfo)
		{
			return gcnew TestRunInfo(gcnew String(testInfo.Name), gcnew String(testInfo.Fixture), gcnew String(testInfo.FileName), testInfo.FileLineNumber);
		}

		array<CallStackElement^>^ CreateCallStack(const CryUnit::SFailureInfo &failureInfo)
		{
			array<CallStackElement^>^ callStack = gcnew array<CallStackElement^>(failureInfo.CallStack.GetSize());
			for (int index = 0; index < failureInfo.CallStack.GetSize(); index++)
			{
				const CryUnit::ICallStackElement& element = failureInfo.CallStack.GetElementByIndex(index);
				callStack[index] = gcnew CallStackElement(gcnew System::String(element.GetFunctionName()), gcnew System::String(element.GetModuleName()), gcnew System::String(element.GetFileName()), element.GetFileLineNumber());
			}
			return callStack;
		}		  

		FailureInfo^ CreateFailureInfo(const CryUnit::SFailureInfo& failureInfo)
		{
			array<CallStackElement^>^ callStack = CreateCallStack(failureInfo);
			return gcnew FailureInfo(gcnew String(failureInfo.Condition), gcnew String(failureInfo.Message), gcnew String(failureInfo.FileName), failureInfo.FileLineNumber, callStack);
		}
	}
}
