#include "stdafx.h"

#include <CryUnitInterfaces.h>

#include "TestListener.h"
#include "Marshall.h"
using namespace System;

namespace CryUnitWrapper 
{

    TestListener::TestListener()
	{
		testListener = new CTestListenerWrapper(this);
	}

	TestListener::~TestListener()
	{
		delete testListener;
	}

    CryUnit::ITestListener* TestListener::GetData()
    {
        return testListener;
    }

	CTestListenerWrapper::CTestListenerWrapper(TestListener^ testListener)
        : m_TestListenerHandle(testListener)
	{

    }

	void CTestListenerWrapper::TestSuiteRun(const CryUnit::ITestSuite& testSuite)
	{
		m_TestListenerHandle->TestSuiteRun(gcnew System::String(testSuite.GetName()));
	}

	void CTestListenerWrapper::TestSuiteEnd(const CryUnit::ITestSuite& testSuite)
	{
		m_TestListenerHandle->TestSuiteEnd(gcnew System::String(testSuite.GetName()));
	}

	void CTestListenerWrapper::StartTestRun(const CryUnit::STestInfo& testInfo)
	{
		m_TestListenerHandle->StartTestRun(Marshall::CreateTestRunInfo(testInfo));
	}

	void CTestListenerWrapper::TestRun(const CryUnit::STestInfo& testInfo)
	{
        m_TestListenerHandle->TestRun(Marshall::CreateTestRunInfo(testInfo));
	}

	void CTestListenerWrapper::TestPassed(const CryUnit::STestInfo& testInfo)
	{
		m_TestListenerHandle->TestPassed(Marshall::CreateTestRunInfo(testInfo));
	}

	void CTestListenerWrapper::TestFailed(const CryUnit::STestInfo& testInfo, const CryUnit::SFailureInfo& failureInfo)
	{
		m_TestListenerHandle->TestFailed(Marshall::CreateTestRunInfo(testInfo), Marshall::CreateFailureInfo(failureInfo));
	}

	void CTestListenerWrapper::TestSkipped(const CryUnit::STestInfo& testInfo)
	{
		m_TestListenerHandle->TestSkipped(Marshall::CreateTestRunInfo(testInfo));
	}
}
