
#pragma once

#include <vcclr.h>

using System::String;

namespace CryUnitWrapper 
{
	class CTestListenerWrapper;
    ref class TestRunInfo;
    ref class FailureInfo;

    public ref class TestListener abstract
	{
	public:
		TestListener();

		virtual ~TestListener();

		virtual void TestSuiteRun(System::String^ suiteName) = 0;

		virtual void TestSuiteEnd(System::String^ suiteName) = 0;

		virtual void StartTestRun(TestRunInfo^ testInfo) = 0;

		virtual void TestRun(TestRunInfo^ testInfo) = 0;

		virtual void TestPassed(TestRunInfo^ testInfo) = 0;

		virtual void TestFailed(TestRunInfo^ testInfo, FailureInfo^ failureInfo) = 0;

		virtual void TestSkipped(TestRunInfo^ testInfo) = 0;

		CryUnit::ITestListener* GetData();

	private:
		CTestListenerWrapper* testListener;
	};

	class CTestListenerWrapper: public CryUnit::ITestListener
	{
	public:
		CTestListenerWrapper(TestListener^ testListener);

		virtual void TestSuiteRun(const CryUnit::ITestSuite& testSuite);

		virtual void TestSuiteEnd(const CryUnit::ITestSuite& testSuite);

		virtual void StartTestRun(const CryUnit::STestInfo& testInfo);

		virtual void TestRun(const CryUnit::STestInfo& testInfo);

		virtual void TestPassed(const CryUnit::STestInfo& testInfo);

        virtual void TestFailed(const CryUnit::STestInfo& testInfo, const CryUnit::SFailureInfo& failureInfo);

		virtual void TestSkipped(const CryUnit::STestInfo& testInfo);

	private:
		gcroot<TestListener^> m_TestListenerHandle;
	};
}
