#include "stdafx.h"
#include <CryUnitInterfaces.h>

#include "TestSuite.h"
#include "TestListener.h"
#include "TestRunInfo.h"
#include "Marshall.h"

#include <memory>
#include <vcclr.h>

using namespace System;
using namespace System::Collections::Generic;
using namespace CryUnitWrapper;

TestSuite::TestSuite(CryUnit::ITestSuite* testSuite)
	: m_testSuite(testSuite)
{
    m_name = gcnew String(testSuite->GetName());
}

void TestSuite::Run(TestListener^ listener)
{
    m_testSuite->Run(*listener->GetData());
}

void TestSuite::RunTestCase(TestRunInfo^ testCase, TestListener^ listener)
{
	char* testName = (char*) System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(testCase->Name).ToPointer();
	const CryUnit::STestInfo* testInfo = m_testSuite->GetTestInfoByName(testName);
	if (testInfo)
	{
		m_testSuite->RunTestCase(*testInfo, *listener->GetData());
	}
	System::Runtime::InteropServices::Marshal::FreeHGlobal(IntPtr(testName));

}

String^ TestSuite::Name::get()
{
    return m_name;
}

String^ TestSuite::Type::get()
{
    String^ res = nullptr;
    switch (m_testSuite->GetType())
    {
    case CryUnit::ITestSuite::UNIT_TEST:
        res = gcnew String("UNIT_TEST");
        break;
    case CryUnit::ITestSuite::SMOKE_TEST:
        res = gcnew String("SMOKE_TEST");
        break;
    default:
        res = gcnew String("UNDEF");
        break;
    }
    return res;
}

IEnumerable<TestRunInfo^>^ TestSuite::TestCases::get()
{
	List<TestRunInfo^>^ testCases = gcnew List<TestRunInfo^>();
	for (unsigned int index = 0; index < m_testSuite->GetNumberOfTests(); ++index)
	{
		TestRunInfo^ testRunInfo = Marshall::CreateTestRunInfo(m_testSuite->GetTestInfoByIndex(index));
		testCases->Add(testRunInfo);
	}
	return testCases;
}
