#pragma once

using System::String;

namespace CryUnit
{
    class ITestSuite;
}

namespace CryUnitWrapper 
{
	ref class TestListener;
	ref class TestRunInfo;

	public ref class TestSuite
	{
	public:
		TestSuite(CryUnit::ITestSuite* testSuite);

		void Run(TestListener^ listener);
		void RunTestCase(TestRunInfo^ testCase, TestListener^ listener);

		property String^ Name { String^ get(); }
		property String^ Type { String^ get(); }

		property System::Collections::Generic::IEnumerable<TestRunInfo^>^ TestCases { System::Collections::Generic::IEnumerable<TestRunInfo^>^ get(); }

	private:
		CryUnit::ITestSuite* m_testSuite;
		String^ m_name;
	};
}
