#pragma once

namespace CryUnit
{
    class ITestEnumerator;
}

namespace CryUnitWrapper
{
    ref class TestSuite;

    public ref class TestSuiteLoader
    {
    public:
        TestSuiteLoader(System::String^ baseDir, System::String^ dllName, bool loadSmokeTest);
        ~TestSuiteLoader();

        property System::Collections::Generic::ICollection<TestSuite^>^ SuiteList { System::Collections::Generic::ICollection<TestSuite^>^ get(); }

    private:
        HMODULE LoadDll(System::String^ basePath, System::String^ dllName);
        CryUnit::ITestEnumerator* GetTestEnumerator(bool loadSmokeTest);
        void InitializeSuiteList();

        HMODULE m_library;
        CryUnit::ITestEnumerator* m_testEnumerator;
        System::Collections::Generic::ICollection<TestSuite^>^ m_suiteList;
    };
}
