#pragma once

#ifndef CONFIG_H
#define CONFIG_H

#include <vector>

class Config
{
private:
	class OptionFlag
	{
	public:
		OptionFlag(const string& name);
		OptionFlag(const string& name, const string& defaultValue);

		bool IsEnabled() const;
		const string& GetValue() const;

		bool Match(const string& arg);
	private:
		string LowerCase(const string& toDowncase) const;
		void TryMatchValue(const string& arg, const string& originalArg, bool& matches);

		string m_name;
		string m_value;
		bool m_enabled;
	};

public:
	Config(int argc, char** argv);

	bool IsSmokeTest() const;
	bool IsReportEnabled() const;
	const string& GetReportDirectory() const ;
	bool IsForceEnabled() const;
	const string GetDllName() const;

private:
	void ParseCommandLine(int argc, char** argv);
	bool MatchOption(const string& arg);

	std::vector<OptionFlag*> m_optionFlags;
	OptionFlag m_reportFlag;
	OptionFlag m_smokeFlag;
	OptionFlag m_forceFlag;

	string m_dllName;
};

#endif
