#include "StdAfx.h"
#include <platform_impl.h>

#include "ConsoleRunner.h"
#include "XmlTestWriter.h"
#include "TestRunner.h"
#include "TestRunnerObserver.h"

#include <CryPath.h>

ConsoleRunner::ConsoleRunner(int argc, char** argv)
	: m_config(argc, argv)
	, m_argc(argc)
	, m_testWriter(CreateTestWriter())
{
	LogConfig();
}

ConsoleRunner::~ConsoleRunner()
{
	delete m_testWriter;
}

int ConsoleRunner::Run()
{
	char envValue[256];
	if (GetEnvironmentVariable("CRY_NO_TESTING", envValue, sizeof(envValue)) && !m_config.IsForceEnabled())
	{
		printf("Skipping tests\n");
		return EXIT_SUCCESS;
	}

	if (!m_testWriter)
	{
		printf("Cannot run test m_testWriter is NULL\n");
		return EXIT_FAILURE;
	}

	TestRunnerObserver runnerObserver(*m_testWriter);
	TestRunner testRunner(runnerObserver);

	if (m_argc == 1)
	{
		testRunner.DisableProtector();
	}

	testRunner.Init(m_config.GetDllName(), m_config.IsSmokeTest() ? CryUnit::ITestSuite::SMOKE_TEST : CryUnit::ITestSuite::UNIT_TEST);
	testRunner.RunTests();

	if (m_argc == 1)
	{
		system("pause");
	}

	return runnerObserver.GetExitCode();

}

void ConsoleRunner::LogConfig() const
{
	printf("Config\n");
	printf("------\n");
	printf("Smoke: %s\n", m_config.IsSmokeTest() ? "true" : "false");
	printf("Report: %s\n", m_config.IsReportEnabled() ? "true" : "false");
	printf("Force: %s\n", m_config.IsForceEnabled() ? "true" : "false");
	printf("ReportDir: %s\n", m_config.GetReportDirectory().c_str());
	printf("DllName: %s\n", m_config.GetDllName().c_str());
	printf("===========================================================\n\n");
}

TestWriter* ConsoleRunner::CreateTestWriter() const
{
	if (!m_config.IsReportEnabled())
	{
		return new TestWriter();
	}

	char buff[256];
	GetCurrentDirectory(sizeof(buff), buff);
	string reportDir = PathUtil::ToUnixPath(PathUtil::Make(buff, m_config.GetReportDirectory()));

	SetLastError(0);
	if (!CreateDirectory(reportDir, NULL) &&  GetLastError() != ERROR_ALREADY_EXISTS)
	{
		printf("Cannot create report folder CurrentPath [%s] ReportDirectory [%s]\n", buff, m_config.GetReportDirectory().c_str());
		return new TestWriter();
	}

	return new XmlTestWriter(reportDir);
}
