#include "StdAfx.h"
#include "TestListener.h"
#include "TestRunnerObserver.h"

TestListener::TestListener(TestRunnerObserver& runnerObserver)
	: m_runnerObserver(runnerObserver)
{

}

void TestListener::TestSuiteRun(const CryUnit::ITestSuite& testSuite)
{
	m_runnerObserver.TestSuiteStart(testSuite.GetName());
}

void TestListener::TestSuiteEnd(const CryUnit::ITestSuite& testSuite)
{
	m_runnerObserver.TestSuiteEnd(testSuite.GetName());
}

void TestListener::StartTestRun(const CryUnit::STestInfo& testInfo)
{
	m_runnerObserver.StartTestRun(testInfo);
}

void TestListener::TestRun(const CryUnit::STestInfo& testInfo)
{
	m_runnerObserver.TestRun(testInfo);
}

void TestListener::TestPassed(const CryUnit::STestInfo& testInfo)
{
	m_runnerObserver.TestPassed(testInfo);
}

void TestListener::TestFailed(const CryUnit::STestInfo& testInfo, const CryUnit::SFailureInfo& failureInfo)
{
	m_runnerObserver.TestFailed(testInfo, failureInfo);
}

void TestListener::TestSkipped(const CryUnit::STestInfo& testInfo)
{
	m_runnerObserver.TestSkipped(testInfo);
}
