#pragma once

#ifndef TEST_LISTENER_H
#define TEST_LISTENER_H

class TestRunnerObserver;

class TestListener : public CryUnit::ITestListener
{
public:
	TestListener(TestRunnerObserver& runnerObserver);
	virtual void TestSuiteRun(const CryUnit::ITestSuite& testSuite);
	virtual void TestSuiteEnd(const CryUnit::ITestSuite& testSuite);

	virtual void StartTestRun(const CryUnit::STestInfo& testInfo);
	virtual void TestRun(const CryUnit::STestInfo& testInfo);
	virtual void TestPassed(const CryUnit::STestInfo& testInfo);
    virtual void TestFailed(const CryUnit::STestInfo& testInfo, const CryUnit::SFailureInfo& failureInfo);
	virtual void TestSkipped(const CryUnit::STestInfo& testInfo);

private:
	TestRunnerObserver& m_runnerObserver;
};

#endif
