#include "StdAfx.h"
#include "TestRunner.h"
#include "TestListener.h"
#include "TestRunnerObserver.h"
#include <ctime>
using namespace CryUnit;

TestRunner::TestRunner(TestRunnerObserver& runnerObserver)
	: m_runnerObserver(runnerObserver)
	, m_testListener(m_runnerObserver)
	, m_protectorEnabled(true)
{

}

void TestRunner::Init(const string& dllName, ITestSuite::Type suiteType)
{
	try
	{
		m_runnerObserver.InitDll(dllName, m_testSuiteLoader.GetBinariesDirectory());
		clock_t beforeLoadDll = std::clock();
		m_testSuiteLoader.Init(dllName, suiteType);
		printf("TestSuiteLoader elapsed time %f\n", float(clock() - beforeLoadDll) / CLOCKS_PER_SEC);
	}
	catch (const TestSuiteLoaderException& exception)
	{
		m_runnerObserver.InitDllFailed(exception);
	}
}

void TestRunner::RunTests()
{
	for (size_t index = 0; index < m_testSuiteLoader.GetNumberOfSuites(); index++)
	{
		CryUnit::ITestSuite* testSuite = m_testSuiteLoader.GetSuiteAt(index);

        if (!m_protectorEnabled)
		{
            testSuite->DisableProtector();
		}

		testSuite->Run(m_testListener);
	}

	m_runnerObserver.EndRunTest();
}

void TestRunner::DisableProtector()
{
    m_protectorEnabled = false;
}
