#pragma once

#ifndef TEST_RUNNER_H
#define TEST_RUNNER_H

#include "TestSuiteLoader.h"
#include "TestRunner.h"
#include "TestListener.h"

class TestRunnerObserver;

class TestRunner
{
public:
	TestRunner(TestRunnerObserver& runnerObserver);

	void Init(const string& dllName, CryUnit::ITestSuite::Type suiteType);

	void RunTests();
	void DisableProtector();

private:
	TestRunnerObserver& m_runnerObserver;
	TestListener m_testListener;
	TestSuiteLoader m_testSuiteLoader;
	bool m_protectorEnabled;
};

#endif
