#pragma once

#ifndef TEST_SUITE_LOADER_H
#define TEST_SUITE_LOADER_H

#include <vector>
#include <exception>

class TestSuiteLoaderException : public std::exception
{
public:
	TestSuiteLoaderException(const string& what, const string& dllName, const string& binariesDirectory);

	const string& GetDllName() const;
	const string& GetBinariesDirectory() const;

private:
	string m_dllName; 
	string m_binariesDirectory;
};

class TestSuiteLoader
{
	typedef std::vector<CryUnit::ITestSuite*> TestSuites;
public:
	TestSuiteLoader();
	~TestSuiteLoader();

	void Init(const string& dllName, CryUnit::ITestSuite::Type suiteType);

	size_t GetNumberOfSuites() const;
	CryUnit::ITestSuite* GetSuiteAt(size_t index) const;

	string GetBinariesDirectory() const;

private:
	void InitTestEnumerator(CryUnit::ITestSuite::Type suiteType);
	string GetRootDirectory() const;
	void ReportError(const string& dllName, const string& binariesDirectory) const;

	string m_rootDirectory;

	void* m_gameModule;
	CryUnit::ITestEnumerator* m_testEnumerator;
	TestSuites m_testSuites;
};

#endif
