#pragma once

#ifndef XML_TEST_WRITER_H
#define XML_TEST_WRITER_H

class XmlWriter;
class TestSuiteContext;
class TestRunInfo;
class TestRunInfo;
class TestFailedInfo;

class TestWriter
{
public:
	virtual ~TestWriter();

	virtual void TestSuiteEnd(const TestSuiteContext& suiteContext);
};

class XmlTestWriter : public TestWriter
{
public:
	XmlTestWriter(const string& xmlPath);

	virtual void TestSuiteEnd(const TestSuiteContext& suiteContext);

private:
	void WriteSuiteAttributes(XmlWriter& writer, const TestSuiteContext& suiteContext);
	void WriteTestCases(XmlWriter& writer, const TestSuiteContext& suiteContext);
	void TestCasePassed(XmlWriter& writer, const TestRunInfo& testRunInfo);
	void TestCaseSkipped(XmlWriter& writer, const TestRunInfo& testRunInfo);
	void TestCaseFailed(XmlWriter& writer, const TestRunInfo& testRunInfo, const TestFailedInfo& testFailedInfo);
	void BeginTestCase(XmlWriter& writer, const TestRunInfo& testRunInfo);
	void EndTestCase(XmlWriter& writer);
	string GetCallStackString(const TestFailedInfo& testFailedInfo) const;

	string m_xmlPath;
};

#endif
