#include "StdAfx.h"
#include "XmlWriter.h"

XmlWriter::Element::Element(const string& name, Element* parent)
	: m_name(name)
	, m_parent(parent)
{

}

XmlWriter::Element::~Element()
{
	for (size_t i = 0; i < m_children.size(); ++i)
	{
		delete m_children[i];
	}
}

XmlWriter::Element* XmlWriter::Element::GetParent() const
{
	return m_parent;
}

void XmlWriter::Element::AddAttribute(const string& name, const string& value)
{
	m_attributes.push_back(std::make_pair(name, value));
}

void XmlWriter::Element::AddChild(Element* element)
{
	m_children.push_back(element);
}

void XmlWriter::Element::SetText(const string& text)
{
	m_text = text;
}

void XmlWriter::Element::SerializeAttributes(string& res) const
{
	for (size_t i = 0; i < m_attributes.size(); ++i)
	{
		res += ' ';
		res += m_attributes[i].first;
		res += "=\"";
		res += m_attributes[i].second;
		res += '"';
	}
}

void XmlWriter::Element::SerializeChildren(string& res) const
{
	for (size_t i = 0; i < m_children.size(); ++i)
	{
		res += m_children[i]->ToString();
	}
}

string XmlWriter::Element::ToString() const
{
	string res;
	res += '<';
	res += m_name;

	SerializeAttributes(res);

	res += '>';

	SerializeChildren(res);

	res += m_text;

	res += "</";
	res += m_name;
	res += '>';
	return res;
}

XmlWriter::XmlWriter()
	: m_root(NULL)
	, m_current(NULL)
{

}

XmlWriter::~XmlWriter()
{
	delete m_root;
}

void XmlWriter::WriteStartElement(const string& name)
{
	Element* newCurrent = new Element(name, m_current);
	if (!m_root)
	{
		m_root = m_current = newCurrent;
	}
	else
	{
		m_current->AddChild(newCurrent);
		m_current = newCurrent;
	}
}

void XmlWriter::WriteAttribute(const string& name, const string& value)
{
	m_current->AddAttribute(name, value);
}

void XmlWriter::WriteAttribute(const string& name, int value)
{
	string stringValue;
	stringValue.Format("%d", value);
	WriteAttribute(name, stringValue);
}

void XmlWriter::WriteCData(const string& text)
{
	string cdata = "<![CDATA[";
	cdata += text;
	cdata += "]]>";

	m_current->SetText(text);
}


void XmlWriter::WriteEndElement()
{
	m_current = m_current->GetParent();
}

string XmlWriter::ToString() const
{
	return m_root->ToString();
}
