#pragma once

#ifndef XML_WRITER_H
#define XML_WRITER_H

class XmlWriter
{
	class Element
	{
	public:
		Element(const string& name, Element* parent);
		~Element();

		Element* GetParent() const;

		void AddAttribute(const string& name, const string& value);
		void AddChild(Element* element);

		void SetText(const string& text);

		string ToString() const;

	private:
		void SerializeAttributes(string& res) const;
		void SerializeChildren(string& res) const;

		string m_name;
		string m_text;
		Element* m_parent;
		std::vector< std::pair<string, string> > m_attributes;
		std::vector< Element* > m_children;
	};

public:
	XmlWriter();

	~XmlWriter();

	void WriteStartElement(const string& name);

	void WriteAttribute(const string& name, const string& value);
	void WriteAttribute(const string& name, int value);

	void WriteEndElement();

	void WriteCData(const string& text);

	string ToString() const;

private:
	Element* m_root;
	Element* m_current;
};

#endif
