#include "StdAfx.h"
#include "DrawSomething.h"

#include <ISystem.h>
#include <IRenderer.h>
#include <IRenderAuxGeom.h>
#include <I3DEngine.h>
#include <CGFContent.h>
#include <Cry_Camera.h>

Mesh::Mesh(I3DEngine* engine, const char* fileName)
		: m_engine(engine)
		, m_cgf(NULL)
		, m_mesh(NULL)
{
	Load(fileName);
}

Mesh::~Mesh()
{
	m_engine->ReleaseChunkFileContent(m_cgf);
}

AABB& Mesh::GetBBox() const
{
	return m_mesh->m_bbox;
}

void Mesh::Load(const char* fileName)
{
	CContentCGF* m_cgf = m_engine->LoadChunkFileContent(fileName);
	if (m_cgf)
	{
		m_mesh = m_cgf->GetMergedMesh();
		if (!m_mesh)
		{
			for (int i = 0; m_mesh == NULL && i < m_cgf->GetNodeCount(); i++)
			{
				if (m_cgf->GetNode(i)->pMesh)
				{
					m_mesh = m_cgf->GetNode(i)->pMesh;
				}
			}
		}
	}
}

DrawSomething::DrawSomething(IRenderer* renderer, I3DEngine* engine)
	:	m_renderer(renderer),  m_engine(engine), m_auxGeom(m_renderer->GetIRenderAuxGeom())
{
	
}

void DrawSomething::DrawTranslatedWireCube()
{
	CCamera camera;
	m_renderer->SetCamera(camera);

	m_renderer->ClearBuffer(FRT_CLEAR_COLOR | FRT_CLEAR_IMMEDIATE, &Col_DarkGray);

	Mesh mesh(m_engine, "Objects\\default.cgf");
	AABB bbox = mesh.GetBBox();

	static float rad = -10.0f;
	rad += 0.01f;
	Matrix34 world;
	world.SetIdentity();
	world.SetRotationZ(rad);
	world.SetTranslation(Vec3(0.0f, 2.0f, 0.0f));

	m_auxGeom->DrawAABB(bbox, world, false, Col_Red, eBBD_Faceted);

	m_auxGeom->DrawLine(Vec3(0.0f, 2.0f, 0.0f), Col_Green, Vec3(1.0f, 2.0f, 0.0f), Col_Green);
	m_auxGeom->DrawLine(Vec3(0.0f, 2.0f, 0.0f), Col_Red, Vec3(0.0f, 3.0f, 0.0f), Col_Red);
	m_auxGeom->DrawLine(Vec3(0.0f, 2.0f, 0.0f), Col_Yellow, Vec3(0.0f, 2.0f, 1.0f), Col_Yellow);
}

void DrawSomething::DrawCenteredWireCubeWithProperAxisAndTranslatedCamera()
{
	CCamera camera;
	camera.SetPosition(Vec3(1.0f, -5.0, 1.0f));
	m_renderer->SetCamera(camera);

	m_renderer->ClearBuffer(FRT_CLEAR_COLOR | FRT_CLEAR_IMMEDIATE, &Col_DarkGray);

	Mesh mesh(m_engine, "Objects\\default.cgf");
	AABB bbox = mesh.GetBBox();

	m_auxGeom->DrawAABB(bbox, false, Col_Red, eBBD_Faceted);

	m_auxGeom->DrawLine(Vec3(0.0f, 0.0f, 0.0f), Col_White, Vec3(2.0f, 0.0f, 0.0f), Col_White);
	m_renderer->DrawLabel(Vec3(2.0f, 0.0f, 0.0f), 2.0f, "x");
	m_auxGeom->DrawLine(Vec3(0.0f, 0.0f, 0.0f), Col_White, Vec3(0.0f, 2.0f, 0.0f), Col_White);
	m_renderer->DrawLabel(Vec3(0.0f, 2.0f, 0.0f), 2.0f, "y");
	m_auxGeom->DrawLine(Vec3(0.0f, 0.0f, 0.0f), Col_White, Vec3(0.0f, 0.0f, 2.0f), Col_White);
	m_renderer->DrawLabel(Vec3(0.0f, 0.0f, 2.0f), 2.0f, "z");
}

void DrawSomething::DrawSolidCube()
{
	CCamera camera;
	camera.SetPosition(Vec3(1.0f, -5.0, 1.0f));
	m_renderer->SetCamera(camera);

	m_renderer->ClearBuffer(FRT_CLEAR_COLOR | FRT_CLEAR_IMMEDIATE, &Col_DarkGray);

	DrawAxes();

	static float rad = -10.0f;
	rad += 0.01f;
	Matrix34 move;
	move.SetIdentity();
	move.SetRotationZ(rad, Vec3(2.0f, 2.0f, 0.0f));

	m_auxGeom->DrawAABB(AABB(Vec3(-0.5f, -0.5f, -0.5f), Vec3(0.5f, 0.5f, 0.5f)), move, true, Col_Aquamarine, eBBD_Faceted);
}

void DrawSomething::Draw()
{
	m_renderer->ClearBuffer(FRT_CLEAR_COLOR | FRT_CLEAR_IMMEDIATE, &Col_DarkGray);

	DrawSolidCube();
}

void DrawSomething::DrawAxes()
{
	Vec3 x(1.0f, 0.0f, 0.0f);
	Vec3 y(0.0f, 1.0f, 0.0f);
	Vec3 z(0.0f, 0.0f, 1.0f);
	Vec3 o(0.0f, 0.0f, 0.0f);
	ColorF color = Col_White;
	float fontSize = 1.0f;

	m_auxGeom->DrawLine(o, color, x, color);
	m_renderer->DrawLabel(x, fontSize, "x");
	m_auxGeom->DrawLine(o, color, y, color);
	m_renderer->DrawLabel(y, fontSize, "y");
	m_auxGeom->DrawLine(o, color, z, color);
	m_renderer->DrawLabel(z, fontSize, "z");
}
