#ifndef REGRESSION_TEST_DRAW_SOMETHING_H
#define REGRESSION_TEST_DRAW_SOMETHING_H

struct IRenderer;
struct I3DEngine;
struct IRenderAuxGeom;
class CMesh;
class CContentCGF;
struct AABB;

class Mesh
{
public:
	Mesh(I3DEngine* engine, const char* fileName);
	~Mesh();

	AABB& GetBBox() const;
	CMesh* GetMesh() const { return m_mesh; }

private:
	void Load(const char* fileName);

private:
	I3DEngine* m_engine;
	CContentCGF* m_cgf;
	CMesh* m_mesh;
};

class DrawSomething
{
public:
	DrawSomething(IRenderer* renderer, I3DEngine* engine);
	void Draw();

private:
	void DrawAxes();
	void DrawTranslatedWireCube();
	void DrawCenteredWireCubeWithProperAxisAndTranslatedCamera();
	void DrawSolidCube();

	IRenderer* m_renderer;
	I3DEngine* m_engine;
	IRenderAuxGeom* m_auxGeom;
};

#endif
