#include "StdAfx.h"

#include "EngineStartup.h"
#include "DrawSomething.h"
#include "ISystem.h"

EngineStartup::EngineStartup()
	: m_system(NULL)
{

}

LRESULT CALLBACK EngineStartup::WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
	case WM_CLOSE:
		PostQuitMessage(0);
		break;
	}

	return DefWindowProc(hwnd, msg, wParam, lParam);
}

bool EngineStartup::Initialize(const char* binaries)
{
	RegisterClass();
	if (!InitDirectories())
	{
		ShowError("Can't initialize directories!");
		return false;
	}

	CreateSystem(binaries);
	ModuleInitISystem(m_system, "RegressionTest");
	MainLoop();

	return true;
}

void EngineStartup::RegisterClass()
{
	WNDCLASSEX wc = { 0 };

	wc.cbSize        = sizeof(WNDCLASSEX);
	wc.style         = CS_OWNDC | CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wc.lpfnWndProc   = WndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = GetModuleHandle(0);
	wc.lpszClassName = "CryENGINE";
	wc.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName  = 0;
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);

	RegisterClassEx(&wc);
}

bool EngineStartup::CreateSystem(const char* binaries)
{
	HMODULE module;
	if (!LoadLibrary(binaries, "CrySystem.dll", &module))
	{
		ShowError("Unable to load CrySystem.dll");
		return false;
	}

	SetCurrentDirectory(m_currDir);
	PFNCREATESYSTEMINTERFACE createSystemInterface = (PFNCREATESYSTEMINTERFACE) GetProcAddress(module, "CreateSystemInterface");
	if (!createSystemInterface)
	{
		ShowError("Unable to find CreateSystemInterface");
		return false;
	}

	SSystemInitParams initParams;
	strcpy_s(initParams.szBinariesDir, binaries);
	m_system = createSystemInterface(initParams);
	if (!m_system)
	{
		ShowError("Unable to create ISystem");
		return false;
	}

	return true;
}

void EngineStartup::MainLoop()
{
	bool quit = false;
	while (!quit)
	{
		MSG msg;
		if (PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
			{
				quit = true;
			}

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
			m_system->Update();
			m_system->RenderBegin();

			DrawSomething drawSomething(m_system->GetIRenderer(), m_system->GetI3DEngine());
			drawSomething.Draw();

			m_system->RenderEnd();
		}
	}
}

