#include <StdAfx.h>
#include "FakeInputDevice.h"

FakeInputDevice::FakeInputDevice(IInput* input)
	: m_input(input)
{

}

const char* FakeInputDevice::GetDeviceName() const
{
	return "FakeInputDevice";
}

EDeviceId FakeInputDevice::GetDeviceId() const
{
	return eDI_Unknown;
}

bool FakeInputDevice::Init()
{
	return true;
}

void FakeInputDevice::Update()
{
	DispatchInputEvent();
}

bool FakeInputDevice::SetForceFeedback(IFFParams params)
{
	return false;
}

bool FakeInputDevice::InputState(const TKeyName& key, EInputState state)
{
	return false;
}

bool FakeInputDevice::SetExclusiveMode(bool value)
{
	return false;
}

void FakeInputDevice::ClearKeyState()
{

}

void FakeInputDevice::ClearAnalogKeyState()
{

}

const char* FakeInputDevice::GetKeyName(const SInputEvent& event, bool bGUI/*=0*/)
{
	return "";
}

const wchar_t* FakeInputDevice::GetOSKeyName(const SInputEvent& event)
{
	return L"";
}

SInputSymbol* FakeInputDevice::LookupSymbol(EKeyId id) const
{
	return NULL;
}

bool FakeInputDevice::IsOfDeviceType( EInputDeviceType type ) const
{
	return true;
}

void FakeInputDevice::Enable(bool enable)
{

}

bool FakeInputDevice::IsEnabled() const
{
	return true;
}

void FakeInputDevice::OnLanguageChange()
{

}

void FakeInputDevice::PushInputEvent(const InputEvent& inputEvent)
{
	m_inputEvents.push(inputEvent);
}

void FakeInputDevice::DispatchInputEvent()
{
	if (!m_inputEvents.empty())
	{
		InputEvent inputEvent = m_inputEvents.front();
		m_input->PostInputEvent(inputEvent.GetData());
		m_inputEvents.pop();
	}
}

IInput* FakeInputDevice::GetIInput()
{
	return m_input;
}
