#ifndef REGRESSION_TEST_FAKE_INPUT_DEVICE_H
#define REGRESSION_TEST_FAKE_INPUT_DEVICE_H

#pragma once

#include <platform.h>
#include <IInput.h>

#include <queue>

#include "InputEvent.h"

class FakeInputDevice : public IInputDevice
{
public:
	FakeInputDevice(IInput* input);
	virtual const char* GetDeviceName() const;
	virtual EDeviceId GetDeviceId() const;

	virtual bool Init();
	virtual void Update();

	virtual bool SetForceFeedback(IFFParams params);

	virtual bool InputState(const TKeyName& key, EInputState state);

	virtual bool SetExclusiveMode(bool value);

	virtual void ClearKeyState();

	virtual void ClearAnalogKeyState();
	virtual const char *GetKeyName(const SInputEvent& event, bool bGUI=0);
	virtual const wchar_t *GetOSKeyName(const SInputEvent& event);
	virtual SInputSymbol* LookupSymbol(EKeyId id) const;
	virtual bool IsOfDeviceType( EInputDeviceType type ) const;
	virtual void Enable(bool enable);
	virtual bool IsEnabled() const;
	virtual void OnLanguageChange();

	void PushInputEvent(const InputEvent& inputEvent);
	void DispatchInputEvent();

	IInput* GetIInput();

private:
	IInput* m_input;
	std::queue<InputEvent> m_inputEvents;
};

#endif
