#include "StdAfx.h"

#include "GameStartup.h"
#include <IGameStartup.h>
#include <IInput.h>
#include <IGameFramework.h>
#include <CryLibrary.h>

#include "FakeInputDevice.h"
#include "LevelSystemListener.h"

GameStartup::GameStartup(const char* levelName)
	: m_fakeInputDevice(NULL)
	, m_levelSystemListener(NULL)
	, m_levelName(levelName)
{

}

bool GameStartup::Initialize(const char* binaries)
{
	if (!InitDirectories())
	{
		ShowError("Can't initialize directories!");
		return false;
	}

	HMODULE gameDll;
	if (!LoadLibrary(binaries, "CryGame.dll", &gameDll))
	{
		ShowError("CryGame.dll not loaded!");
		return false;
	}

	IGameStartup::TEntryFunction createGameStartup = (IGameStartup::TEntryFunction)CryGetProcAddress(gameDll, "CreateGameStartup");
	if (!createGameStartup)
	{
		ShowError("CreateGameStartup not found in CryGame.dll!");
		return false;
	}

	IGameStartup *gameStartup = createGameStartup();
	if (!gameStartup)
	{
		ShowError("Failed to create the GameStartup Interface!");
		return false;
	}

	if (!InitGameStartup(binaries, gameStartup))
	{
		ShowError("Failed to initialize GameStartup Interface!");
		return false;
	}

	InitFakeInput();

	gameStartup->Run(m_levelName);

	return true;
}

bool GameStartup::InitGameStartup(const char* binaries, IGameStartup* gameStartup)
{
	bool res = false;
	SetCurrentDirectory(m_currDir);

	SSystemInitParams startupParams;
	startupParams.hInstance = GetModuleHandle(0);
	strcpy_s(startupParams.szBinariesDir, binaries);

	if (gameStartup->Init(startupParams))
	{
		gEnv = startupParams.pSystem->GetGlobalEnvironment();
		res = true;
	}
	return res;
}

void GameStartup::InitFakeInput()
{
	m_fakeInputDevice = new FakeInputDevice(gEnv->pInput);
	m_levelSystemListener = new LevelSystemListener(m_fakeInputDevice);

	gEnv->pInput->AddInputDevice(m_fakeInputDevice);
	gEnv->pGame->GetIGameFramework()->GetILevelSystem()->AddListener(m_levelSystemListener);
}
