#ifndef REGRESSION_TEST_LEVEL_SYSTEM_LISTENER_H
#define REGRESSION_TEST_LEVEL_SYSTEM_LISTENER_H

#pragma once

#include <vector>
#include <IConsole.h>
#include <ILevelSystem.h>

class FakeInputDevice;

class LevelSystemListener : public ILevelSystemListener
{
public:
	LevelSystemListener(FakeInputDevice* fakeInputDevice);

	virtual void OnLevelNotFound(const char *levelName);
	virtual void OnLoadingStart(ILevelInfo *pLevel);
	virtual void OnLoadingComplete(ILevel *pLevel);
	virtual void OnLoadingError(ILevelInfo *pLevel, const char *error);
	virtual void OnLoadingProgress(ILevelInfo *pLevel, int progressAmount);

private:
	FakeInputDevice* m_fakeInputDevice;
};

#endif
