#include "StdAfx.h"
#include <platform_impl.h>

#include "Startup.h"

Startup::Startup()
{
	m_currDir[0] = '\0';
}

Startup::~Startup()
{

}

void Startup::ShowError(const char* errorMessage)
{
	MessageBox(NULL, errorMessage, "Error", MB_ICONEXCLAMATION | MB_OK);
}

bool Startup::InitDirectories()
{
	bool res = false;

	GetModuleFileName(GetModuleHandle(0), m_currDir, sizeof(m_currDir));

	return ConvertToBin(m_currDir);
}

bool Startup::ConvertToBin(char* moduleFileName) const
{
	const char* lookFor = "Bin";
	int lookForLen =  strlen(lookFor);

	for (int i = strlen(moduleFileName) - 1; i >= 0; i--)
	{
		if (0 == strncmp(&moduleFileName[i], lookFor, lookForLen))
		{
			moduleFileName[i] = '\0';
			return true;
		}
	}
	return false;
}

bool Startup::LoadLibrary(const char* binaries, const char* library, HMODULE* module)
{
	char binFullPath[256];
	strcpy_s(binFullPath, m_currDir);
	strcat_s(binFullPath, binaries);
	SetCurrentDirectory(binFullPath);
	*module = CryLoadLibrary(library);

	return (*module) ? true : false;
}
