using System;
using CryUnitWrapper;

namespace TestRunner
{
    class Runner
    {
        class Listener : TestListener
        {
            private RunnerObserver m_runnerObserver;

            public Listener(RunnerObserver runnerObserver)
            {
                m_runnerObserver = runnerObserver;
            }

		    public override void TestSuiteRun(string suiteName)
            {
                m_runnerObserver.TestSuiteStart(suiteName);
            }

            public override void TestSuiteEnd(string suiteName)
            {
                m_runnerObserver.TestSuiteEnd(suiteName);
            }

            public override void StartTestRun(TestRunInfo testInfo)
            {
                m_runnerObserver.StartTestRun(testInfo);
            }

            public override void TestRun(TestRunInfo testInfo)
            {
                m_runnerObserver.TestRun(testInfo);
            }

            public override void TestPassed(TestRunInfo testInfo)
            {
                m_runnerObserver.TestPassed(testInfo);
            }

            public override void TestFailed(TestRunInfo testInfo, FailureInfo failureInfo)
            {
                m_runnerObserver.TestFailed(testInfo, failureInfo);
            }

            public override void TestSkipped(TestRunInfo testInfo)
            {
                m_runnerObserver.TestSkipped(testInfo);
            }
        }

        private Config m_config;
        private RunnerObserver m_observer;
        private Listener m_listener;

        public Runner(Config config, RunnerObserver observer)
        {
            m_config = config;
            m_observer = observer;
            m_listener = new Listener(m_observer);
        }

        public void RunTests()
        {
            foreach (string dllName in m_config.DllNames)
            {
                m_observer.StartRunTestInDll(m_config.BaseDir, dllName);
                RunTestsInDll(m_config, dllName);
                m_observer.EndRunTestInDll();
            }
        }

        private void RunTestsInDll(Config config, string dllName)
        {
            try
            {
                DateTime start = DateTime.Now;
                TestSuiteLoader suiteLoader = new TestSuiteLoader(config.BaseDir, dllName, config.EnableSmokeTests);
                TimeSpan elapsed = DateTime.Now.Subtract(start);
                Console.WriteLine("TestSuiteLoader elapsed time {0}", elapsed.TotalSeconds.ToString());
                foreach (TestSuite testSuite in suiteLoader.SuiteList)
                {
                    testSuite.Run(m_listener);
                }
            }
            catch (Exception exception)
            {
                m_observer.FatalError(exception);
            }
        }
    }
}
