﻿using System;
using System.Collections.Generic;
using System.Text;

namespace TestInterface
{
	[Serializable]
	public class AnimationTestingRunInfo
	{
		private string testName;
		private string animationName;
		private string characterName;

		public AnimationTestingRunInfo(string testName, string animationName, string characterName)
		{
			this.testName = testName;
			this.animationName = animationName;
			this.characterName = characterName;
		}

		public string TestName
		{
			get { return testName; }
		}

		public string AnimationName
		{
			get { return animationName; }
		}

		public string CharacterName
		{
			get { return characterName; }
		}
	}
	

	[Serializable]
	public class AnimationTestingFlushEvengArgs : EventArgs
	{
		private bool isOK;

		public AnimationTestingFlushEvengArgs(bool isOK)
		{
			this.isOK = isOK;
		}

		public bool IsOK
		{
			get { return isOK; }
		}
	}

	[Serializable]
	public class AnimationTestingRunInfoEventArgs : EventArgs
	{
		private AnimationTestingRunInfo runInfo;

		public AnimationTestingRunInfoEventArgs(AnimationTestingRunInfo runInfo)
		{
			this.runInfo = runInfo;
		}

		public AnimationTestingRunInfo RunInfo
		{
			get { return runInfo; }
		}
	}

	[Serializable]
	public class AnimationTestingFatalErrorEventArgs : EventArgs
	{
		private string message;

		public AnimationTestingFatalErrorEventArgs(string message)
		{
			this.message = message;
		}

		public string Message
		{
			get { return message; }
		}
	}

	[Serializable]
	public class AnimationSuiteNode : TreeNode
	{
		[NonSerialized]
		private AnimationTesting.Engine animationEngine;

		[NonSerialized]
		private AnimationTesting.Suite animationSuite;

		public AnimationSuiteNode(AnimationTesting.Engine animationEngine, AnimationTesting.Suite animationSuite, TreeNode parent)
		    : base("AnimationSuite", parent)
		{
		    this.animationEngine = animationEngine;
		    this.animationSuite = animationSuite;
		}

		public override void Run(TestListener listener)
		{
			AnimationTesting.OutputWriter outputWriter = listener.CreateAnimationOutputWriter();
			AnimationTesting.Runner runner = new AnimationTesting.Runner(animationEngine, outputWriter);
			runner.Run(animationSuite);
			outputWriter.Flush();
		}
	}

	[Serializable]
	public class AnimationTestTree : CommonTestTree
	{
		[NonSerialized]
		private AnimationTesting.Engine animationEngine;

		public AnimationTestTree(AnimationTesting.Engine animationEngine, AnimationTesting.Suite animationSuite)
			: base("RootAnimation", null)
		{
			this.animationEngine = animationEngine;

			Add(animationSuite);
		}

		private void Add(AnimationTesting.Suite animationSuite)
		{
			AnimationSuiteNode suiteNode = new AnimationSuiteNode(animationEngine, animationSuite, this);
			AddChild(suiteNode);
			
			TreeNode fixtureNode = new TreeNode("AnimationFixture", suiteNode);
			suiteNode.AddChild(fixtureNode);

			foreach (AnimationTesting.Test test in animationSuite)
			{
				TreeNode testNode = new TreeNode(string.Format("{0}<{1}>", test.Name, test.Class), fixtureNode);
				fixtureNode.AddChild(testNode);
			}
		}

		public override void Run(TestListener listener)
		{
			foreach (TreeNode treeNode in Children.Values)
			{
				treeNode.Run(listener);
			}
		}

		public override TreeNode FindFixture(string fixtureName)
		{
			return null;
		}

		public override int ComputeNumberOfTests()
		{
			return 1;
		}
	}
}
