﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using System.Runtime.Remoting;
using System.Runtime.Serialization.Formatters;

namespace TestInterface
{
	public class RemotingBase
	{
		private TcpChannel tcpChannel;

		public RemotingBase(int serverPort)
		{
			BinaryServerFormatterSinkProvider serverSinkProvider = new BinaryServerFormatterSinkProvider();
			serverSinkProvider.TypeFilterLevel = TypeFilterLevel.Full;

			BinaryClientFormatterSinkProvider clientSinkProvider = new BinaryClientFormatterSinkProvider();

			IDictionary properties = new Hashtable();
			properties["port"] = serverPort;

			tcpChannel = new TcpChannel(properties, clientSinkProvider, serverSinkProvider);
			Register();
		}

		private void Register()
		{
			ChannelServices.RegisterChannel(tcpChannel, false);
		}

		public void Close()
		{
			ChannelServices.UnregisterChannel(tcpChannel);
		}
	}
}
