﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using System.Runtime.Remoting;

namespace TestInterface
{
	public class RemotingClient<T> : RemotingBase
	{
		private T remoteObject;

		public RemotingClient(string serverLocation, int serverPort, int eventListenPort, string publishedObjectName)
			: base(eventListenPort)
		{
			remoteObject = (T)Activator.GetObject(typeof(T), string.Format("tcp://{0}:{1}/{2}", serverLocation, serverPort, publishedObjectName));
		}

		public T RemoteObject
		{
			get { return remoteObject; }
		}
	}
}
