﻿using System;
using CryUnitWrapper;

namespace TestInterface
{
	public class TestListener : CryUnitWrapper.TestListener
	{
		private TestShell shell;

		public TestListener(TestShell shell)
		{
			this.shell = shell;
		}

		public override void StartTestRun(TestRunInfo testInfo)
		{

		}

		public override void TestFailed(TestRunInfo testInfo, FailureInfo failureInfo)
		{
			shell.NotifyTestFailed(testInfo, failureInfo);
		}

		public override void TestPassed(TestRunInfo testInfo)
		{
			shell.NotifyTestPassed(testInfo);
		}

		public override void TestRun(TestRunInfo testInfo)
		{

		}

		public override void TestSkipped(TestRunInfo testInfo)
		{
			shell.NotifyTestSkipped(testInfo);
		}

		public override void TestSuiteEnd(string suiteName)
		{
			Console.WriteLine("TestSuiteEnd " + suiteName);
			shell.NotifySuiteEnd(suiteName);
		}

		public override void TestSuiteRun(string suiteName)
		{
			shell.NotifySuiteStart(suiteName);
		}

		class AnimationOutputWriter : AnimationTesting.OutputWriter
		{
			private bool isOK = true;
			private TestShell testShell;

			public AnimationOutputWriter(TestShell testShell)
			{
				this.testShell = testShell;
			}

			public void FatalError(AnimationTesting.Test test, AnimationTesting.CharacterAssertException characterException)
			{
				testShell.NotifyAnimationTestingFatalError(string.Format("Test [{0}] Class [{1}] Character [{2}] Condition [{3}] Message [{4}]", test.Name, test.Class, characterException.CharacterName, characterException.Condition, characterException.Message));
				isOK = false;
			}

			public void FatalError(AnimationTesting.Test test, AnimationTesting.CharacterException characterException)
			{
				testShell.NotifyAnimationTestingFatalError(string.Format("Test [{0}] Class [{1}] Character [{2}]", test.Name, test.Class, characterException.CharacterName));
				isOK = false;
			}

			public void Flush()
			{
				testShell.NotifyAnimationTestingFlush(isOK);
			}

			public void TestClassNotFound(AnimationTesting.Test test)
			{
				testShell.NotifyAnimationTestingFatalError(string.Format("ClassNotFound Test [{0}] Class [{1}]", test.Name, test.Class));
				isOK = false;
			}

			public void TestFailed(AnimationTesting.TestContext testContext, AnimationTesting.TestRunInfo testRunInfo)
			{
				testShell.NotifyAnimationTestingTestFailed(new AnimationTestingRunInfo(testContext.TestName, testContext.AnimationName, testContext.CharacterName));
				isOK = false;
			}

			public void TestPassed(AnimationTesting.TestContext testContext, AnimationTesting.TestRunInfo testRunInfo)
			{
				testShell.NotifyAnimationTestingTestPassed(new AnimationTestingRunInfo(testContext.TestName, testContext.AnimationName, testContext.CharacterName));
			}
		}

		public AnimationTesting.OutputWriter CreateAnimationOutputWriter()
		{
			return new AnimationOutputWriter(shell);
		}
	}
}
