﻿using System;
using CryUnitWrapper;

namespace TestInterface
{
	[Serializable]
	public class TestShellLoadEventArgs : EventArgs
	{
		private CommonTestTree testTree;
		private bool showAnimationTestConsole;

		public TestShellLoadEventArgs(CommonTestTree testTree, bool showTestConsole)
		{
			this.testTree = testTree;
			this.showAnimationTestConsole = showTestConsole;
		}

		public bool ShowAnimationTestConsole
		{
			get { return showAnimationTestConsole; }
		}

		public CommonTestTree TestTree
		{
			get { return testTree; }
		}
	}

	[Serializable]
	public class TestSuiteInfoEventArgs : EventArgs
	{
		private string suiteName;

		public TestSuiteInfoEventArgs(string suiteName)
		{
			this.suiteName = suiteName;
		}

		public string SuiteName
		{
			get { return suiteName; }
		}
	}

	[Serializable]
	public class TestRunInfoEventArgs : EventArgs
	{
		private TestRunInfo testRunInfo;

		public TestRunInfoEventArgs(TestRunInfo testRunInfo)
		{
			this.testRunInfo = testRunInfo;
		}

		public TestRunInfo TestRunInfo
		{
			get { return testRunInfo; }
		}
	}

	[Serializable]
	public class TestFailedInfoEventArgs : TestRunInfoEventArgs
	{
		private FailureInfo failureInfo;

		public TestFailedInfoEventArgs(TestRunInfo testRunInfo, FailureInfo failureInfo)
			: base(testRunInfo)
		{
			this.failureInfo = failureInfo;
		}

		public FailureInfo FailureInfo
		{
			get { return failureInfo; }
		}
	}
}
