﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace TestViewer
{
	public partial class AnimationTestXMLGeneratorForm : Form
	{
		public AnimationTestXMLGeneratorForm()
		{
			InitializeComponent();
		}

		private void buttonGenerate_Click(object sender, EventArgs e)
		{
			try
			{
				Process process = new Process();

				process.StartInfo.CreateNoWindow = true;
				process.StartInfo.UseShellExecute = false;

				process.StartInfo.FileName = textBoxExecutable.Text;
				process.StartInfo.Arguments = string.Format("{0} {1}", textBoxSource.Text, textBoxDestination.Text);

				process.Start();
				process.WaitForExit();

				MessageBox.Show(process.ExitCode == 0 ? "Done" : "Fail");
			}
			catch (Exception exception)
			{
				MessageBox.Show(exception.Message);
			}
		}

		private string GetFileName()
		{
			OpenFileDialog openFileDialog = new OpenFileDialog();
			if (DialogResult.OK == openFileDialog.ShowDialog())
			{
				return openFileDialog.FileName;
			}
			return string.Empty;
		}

		private void buttonExecutable_Click(object sender, EventArgs e)
		{
			string res = GetFileName();
			if (res != string.Empty)
			{
				textBoxExecutable.Text = res;
			}
		}

		private void buttonSourceFile_Click(object sender, EventArgs e)
		{
			string res = GetFileName();
			if (res != string.Empty)
			{
				textBoxSource.Text = res;
			}
		}

		private void buttonSourceFolder_Click(object sender, EventArgs e)
		{
			FolderBrowserDialog folderBrowserDialog = new FolderBrowserDialog();
			if (DialogResult.OK == folderBrowserDialog.ShowDialog())
			{
				textBoxSource.Text = folderBrowserDialog.SelectedPath;
			}
		}

		private void buttonDestination_Click(object sender, EventArgs e)
		{
			string res = GetFileName();
			if (res != string.Empty)
			{
				textBoxDestination.Text = res;
			}
		}
	}
}
