﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace TestViewer
{
	public partial class ColoredProgressBar : UserControl
	{
		private SolidBrush brush = new SolidBrush(Color.Green);
		private int maxValue = 100;
		private int value = 0;

		public ColoredProgressBar()
		{
			InitializeComponent();
			SetStyle(ControlStyles.UserPaint | ControlStyles.AllPaintingInWmPaint | ControlStyles.OptimizedDoubleBuffer, true);
		}

		public int Value
		{
			get { return value; }
			set 
			{
				this.value = value; 
				Invalidate();
			}
		}

		public int MaxValue
		{
			get { return maxValue; }
			set { maxValue = value; }
		}

		public Color Color
		{
			set { brush = new SolidBrush(value); }
			get { return brush.Color; }
		}

		private void DrawBorder(Graphics graphics)
		{
			Rectangle borderRect = new Rectangle(0, 0, ClientRectangle.Width - 1, ClientRectangle.Height - 1);
			graphics.DrawRectangle(new Pen(Color.Black, 1), borderRect);
		}

		private void ColoredProgressBar_Paint(object sender, PaintEventArgs eventArgs)
		{
			DrawBorder(eventArgs.Graphics);
			Rectangle clientRectangle = this.ClientRectangle;

			float coloredWidth = 0;
			if (maxValue != 0)
			{
				coloredWidth = value * (clientRectangle.Width - 2) / maxValue;
			}

			eventArgs.Graphics.FillRectangle(brush, 1, 1, coloredWidth, clientRectangle.Height - 2);
		}

		private void ColoredProgressBar_Resize(object sender, EventArgs e)
		{
			Invalidate();
		}
	}
}
