﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using System.Runtime.Remoting;

using TestInterface;
using Forms = System.Windows.Forms;

namespace TestViewer
{
	public delegate void RemoteTestExecutorStartHandler();
	public delegate void RemoteTestExecutorStopHandler();

	public class RemoteTestExecutor
	{
		private class Vistitor : TestTreeVisitor
		{
			private RemoteTestProcess testProcess;

			public Vistitor(RemoteTestProcess testProcess)
			{
				this.testProcess = testProcess;
			}

			public void Visit(SuiteNode suiteNode)
			{
				testProcess.RemoteObject.RunSuite(suiteNode.Name);
			}

			public void Visit(FixtureNode fixtureNode)
			{
				testProcess.RemoteObject.RunFixture(fixtureNode.Name);
			}

			public void Visit(TestNode node)
			{
				testProcess.RemoteObject.RunTest(node.Name, node.Parent.Name);
			}
		}

		private RemoteTestProcess testProcess;
		public event RemoteTestExecutorStartHandler OnStart;
		public event RemoteTestExecutorStopHandler OnStop;

		public RemoteTestExecutor(RemoteTestExecutorListener testExecutorListener)
		{
			testProcess = new RemoteTestProcess(testExecutorListener, OnProcessClosed);
		}

		public void Start()
		{
			testProcess.Start();

			if (OnStart != null)
			{
				OnStart();
			}
		}

		private void OnProcessClosed()
		{
			if (OnStop != null)
			{
				OnStop();
			}
		}

		public void Stop()
		{
			testProcess.Stop();
		}

		public bool IsRunning()
		{
			return testProcess.IsRunning();
		}

		public void LoadUnit()
		{
			testProcess.RemoteObject.LoadUnit();
		}

		public void LoadSmoke()
		{
			testProcess.RemoteObject.LoadSmoke();
		}

		public void LoadAnimationEngine(string suiteFileName)
		{
			testProcess.RemoteObject.LoadAnimationEngine(suiteFileName);
		}

		public void RunAll()
		{
			testProcess.RemoteObject.RunAll();
		}

		public void Run(TreeNode testTreeNode)
		{
			testTreeNode.AcceptVisitor(new Vistitor(testProcess));
		}
	}
}
