﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Diagnostics;

using TestInterface;
using System.Threading;

namespace TestViewer
{
	public delegate void RemoteTestProcessCloseHandler();

	public class RemoteTestProcess
	{
		private Process process;
		private RemotingClient<TestShell> remotingClient;
		private RemoteTestExecutorListener testExecutorListener;
		private RemoteTestProcessCloseHandler onProcessClosed;

		public RemoteTestProcess(RemoteTestExecutorListener testExecutorListener, RemoteTestProcessCloseHandler onProcessClosed)
		{
			process = null;
			remotingClient = null;
			this.testExecutorListener = testExecutorListener;
			this.onProcessClosed = onProcessClosed;
		}

		private void CreateRemoteObject()
		{
			remotingClient = new RemotingClient<TestShell>(Config.TestExecutorLocation, Config.TestExecutorPort, Config.TestViewerPort, Config.TestShellObjectName);
			remotingClient.RemoteObject.OnLoad += testExecutorListener.OnLoadDone;
			remotingClient.RemoteObject.OnSuiteStart += testExecutorListener.OnSuiteStart;
			remotingClient.RemoteObject.OnSuiteEnd += testExecutorListener.OnSuiteEnd;
			remotingClient.RemoteObject.OnTestPassed += testExecutorListener.OnTestPassed;
			remotingClient.RemoteObject.OnTestFailed += testExecutorListener.OnTestFailed;
			remotingClient.RemoteObject.OnTestSkipped += testExecutorListener.OnTestSkipped;
			remotingClient.RemoteObject.OnAnimationTestingFlush += testExecutorListener.OnAnimationTestingFlush;
			remotingClient.RemoteObject.OnAnimationTestingTestPassed += testExecutorListener.OnAnimationTestingTestPassed;
			remotingClient.RemoteObject.OnAnimationTestingTestFailed += testExecutorListener.OnAnimationTestingTestFailed;
			remotingClient.RemoteObject.OnAnimationTestingFatalError += testExecutorListener.OnAnimationTestingFatalError;
		}

		private void StartProcess()
		{
			process = new Process();
			process.EnableRaisingEvents = true;
			process.Exited += OnProcessExited;
			process.StartInfo.FileName = Config.TestExecutor;

			if (!Config.ShowTestExecutorShell)
			{
				process.StartInfo.CreateNoWindow = true;
				process.StartInfo.UseShellExecute = false;
			}
			string currentdir = Environment.CurrentDirectory;
			process.Start();
		}

		private void OnProcessExited(object sender, EventArgs e)
		{
			remotingClient.Close();
			onProcessClosed();
		}

		public bool IsRunning()
		{
			return process != null && !process.HasExited;
		}

		public void Start()
		{
			StartProcess();
			CreateRemoteObject();
		}

		public void Stop()
		{
			remotingClient.RemoteObject.Close();
			process.Kill();
		}

		public TestShell RemoteObject
		{
			get { return remotingClient.RemoteObject; }
		}
	}
}
