// fsplugin.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "fsplugin.h"
#include "windows.h"
#include <Xbdm.h>

#pragma warning(disable : 4996)

#define pluginrootlen 1


#include <string>

using namespace std;

struct  CPluginConfig {
  string m_strXBOXName;
  string m_strPath;

  char m_strDriveList[128];
  DWORD m_dwDriveCount;
  DWORD m_iCurrentDrive;


  PDM_WALK_DIR m_pWalkDir;



  const char * GetDrive(DWORD num) {

    if (num >= m_dwDriveCount)
      return 0;

    char str[128];
    strcpy(str, m_strDriveList);
    char * pFirst = str;
    pFirst = strtok( pFirst, "," ); 
    for (DWORD i = 0; i < num && pFirst; ++i) {
      pFirst = strtok( NULL, "," ); 
    }

    static char res[128];

    char * pLast = strtok( NULL, "," ); 
    if (!pLast)
      pLast = str + strlen(m_strDriveList);

    memset(res,0, sizeof(res));
    std::copy(pFirst, pLast, res);

    return res;
  }

} pluginConfig;



char* strlcpy(char* p,char*p2,int maxlen)
{
  if ((int)strlen(p2)>=maxlen) {
    strncpy(p,p2,maxlen);
    p[maxlen]=0;
  } else
    strcpy(p,p2);
  return p;
}

BOOL APIENTRY DllMain( HANDLE hModule, 
                      DWORD  ul_reason_for_call, 
                      LPVOID lpReserved
                      )
{
  // TODO!
  //pluginConfig.m_strTempFile = "c:\\temp.txt";
  pluginConfig.m_strXBOXName = "alexey";
  return TRUE;
}

int PluginNumber;
tProgressProc ProgressProc;
tLogProc LogProc;
tRequestProc RequestProc;

int __stdcall FsInit(int PluginNr,tProgressProc pProgressProc,tLogProc pLogProc,tRequestProc pRequestProc)
{
  ProgressProc=pProgressProc;
  LogProc=pLogProc;
  RequestProc=pRequestProc;
  PluginNumber=PluginNr;
  return 0;
}

typedef struct {
  char Path[MAX_PATH];
  char LastFoundName[MAX_PATH];
  HANDLE searchhandle;
} tLastFindStuct,*pLastFindStuct;

HANDLE __stdcall FsFindFirst(char* Path,WIN32_FIND_DATA *FindData)
{
  //  char buf[MAX_PATH];
  pLastFindStuct lf;

  memset(FindData,0,sizeof(WIN32_FIND_DATA));
  if (strcmp(Path,"\\")==0) {
    FindData->dwFileAttributes=FILE_ATTRIBUTE_DIRECTORY;
    FindData->ftLastWriteTime.dwHighDateTime=0xFFFFFFFF;
    FindData->ftLastWriteTime.dwLowDateTime=0xFFFFFFFE;
    lf=(pLastFindStuct)malloc(sizeof(tLastFindStuct));
    strcpy(lf->Path,Path);
    lf->searchhandle=INVALID_HANDLE_VALUE;

    DmGetDriveList(pluginConfig.m_strDriveList, &pluginConfig.m_dwDriveCount);

    if (pluginConfig.m_dwDriveCount > 0) {


      std::string drive = pluginConfig.GetDrive(0);
      drive += ":";
      pluginConfig.m_iCurrentDrive = 1;

      strcpy(lf->LastFoundName,drive.c_str());
      strcpy(FindData->cFileName,drive.c_str());
      return (HANDLE)lf;
    } else {
      free(lf);
      return INVALID_HANDLE_VALUE;
    }
  } else {


    HRESULT hr;
    if (pluginConfig.m_pWalkDir)
      DmCloseDir(pluginConfig.m_pWalkDir);

    pluginConfig.m_pWalkDir = NULL;

    std::string path = Path + 1;
    path += "\\";
    pluginConfig.m_strPath = path;

    DM_FILE_ATTRIBUTES fileAttr;
    hr = DmWalkDir( &pluginConfig.m_pWalkDir, path.c_str(), &fileAttr);
    if( hr == XBDM_NOERR )
    {

      lf=(pLastFindStuct)malloc(sizeof(tLastFindStuct));
      strcpy(lf->Path,path.c_str());
      strcpy(lf->LastFoundName,fileAttr.Name);
      lf->searchhandle=pluginConfig.m_pWalkDir;

      strcpy(FindData->cFileName,fileAttr.Name);
      FindData->nFileSizeLow = fileAttr.SizeLow;
      FindData->nFileSizeHigh = fileAttr.SizeHigh;
      FindData->dwFileAttributes = fileAttr.Attributes;
      FindData->ftCreationTime = fileAttr.CreationTime;
      FindData->ftLastWriteTime = fileAttr.ChangeTime;

      return (HANDLE)lf;
    } else {
      SetLastError(ERROR_NO_MORE_FILES);
    }

    DmCloseDir(pluginConfig.m_pWalkDir);
    pluginConfig.m_pWalkDir = 0;

  }
  return INVALID_HANDLE_VALUE;
}

BOOL __stdcall FsFindNext(HANDLE Hdl,WIN32_FIND_DATA *FindData)
{
  pLastFindStuct lf;

  if ((int)Hdl==1)
    return false;

  lf=(pLastFindStuct)Hdl;
  if (lf->searchhandle==INVALID_HANDLE_VALUE) {   // drive list!
    if (pluginConfig.m_iCurrentDrive < pluginConfig.m_dwDriveCount) {

      std::string drive = pluginConfig.GetDrive(pluginConfig.m_iCurrentDrive);
      drive += ":";
      strcpy(lf->LastFoundName, drive.c_str());
      strcpy(FindData->cFileName,drive.c_str());
      pluginConfig.m_iCurrentDrive++;
      return true;
    } else {
      return false;
    }
  } else {

    DM_FILE_ATTRIBUTES fileAttr;
    HRESULT hr = DmWalkDir( &pluginConfig.m_pWalkDir, pluginConfig.m_strPath.c_str(), &fileAttr);
    if( hr == XBDM_NOERR )
    {
      strcpy(FindData->cFileName,fileAttr.Name);
      FindData->nFileSizeLow = fileAttr.SizeLow;
      FindData->nFileSizeHigh = fileAttr.SizeHigh;
      FindData->dwFileAttributes = fileAttr.Attributes;
      FindData->ftCreationTime = fileAttr.CreationTime;
      FindData->ftLastWriteTime = fileAttr.ChangeTime;

      return TRUE;
    }
  }

  if (pluginConfig.m_pWalkDir) {
    DmCloseDir(pluginConfig.m_pWalkDir);
    pluginConfig.m_pWalkDir = 0;
  }

  return FALSE;
}

int __stdcall FsFindClose(HANDLE Hdl)
{
  //if ((int)Hdl==1)
  //  return 0;

  if (pluginConfig.m_pWalkDir) {
    DmCloseDir(pluginConfig.m_pWalkDir);
    pluginConfig.m_pWalkDir = 0;
  }

  pLastFindStuct lf;
  lf=(pLastFindStuct)Hdl;
  if (lf) {
    free(lf);
  }

  return 0;
}

BOOL __stdcall FsMkDir(char* Path)
{
  char buf[MAX_PATH];
  if (strlen(Path)<pluginrootlen+2)
    return false;
  strlcpy(buf,Path,pluginrootlen);
  return DmMkdir(Path+pluginrootlen) == XBDM_NOERR;
}

int __stdcall FsExecuteFile(HWND MainWin,char* RemoteName,char* Verb)
{
  //SHELLEXECUTEINFO shex;
  //if (strlen(RemoteName)<pluginrootlen+2)
  //  return FS_EXEC_ERROR;
  //if (stricmp(Verb,"open")==0) {
  //  return FS_EXEC_YOURSELF;
  //} else if (stricmp(Verb,"properties")==0) {
  //  memset(&shex,0,sizeof(shex));
  //  shex.fMask=SEE_MASK_INVOKEIDLIST;
  //  shex.cbSize=sizeof(shex);
  //  shex.nShow=SW_SHOW;
  //  shex.hwnd=MainWin;
  //  shex.lpVerb=Verb;
  //  shex.lpFile=RemoteName+pluginrootlen;
  //  if (!ShellExecuteEx(&shex))
  //    return FS_EXEC_ERROR;
  //  else
  //    return FS_EXEC_OK;

  //} else
    return FS_EXEC_ERROR;
}

int __stdcall FsRenMovFile(char* OldName,char* NewName,BOOL Move,BOOL OverWrite,RemoteInfoStruct* ri)
{
  if (strlen(OldName)<pluginrootlen+2 || strlen(NewName)<pluginrootlen+2)
    return FS_FILE_NOTFOUND;

  int err=ProgressProc(PluginNumber,OldName,NewName,0);
  if (err)
    return FS_FILE_USERABORT;

  if (Move) {
    if (OverWrite)
      // CHECKTHIS
      DmDeleteFile(NewName+pluginrootlen, FALSE);
    if (DmRenameFile(OldName+pluginrootlen,NewName+pluginrootlen))
      return FS_FILE_OK;
  } else {
    if (CopyFile(OldName+pluginrootlen,NewName+pluginrootlen,!OverWrite))
      return FS_FILE_OK;
  }
  switch(GetLastError()) {
case ERROR_FILE_NOT_FOUND:
case ERROR_PATH_NOT_FOUND:
case ERROR_ACCESS_DENIED:
  return FS_FILE_NOTFOUND;
case ERROR_FILE_EXISTS:
  return FS_FILE_EXISTS;
default:
  return FS_FILE_WRITEERROR;
  }
  err=ProgressProc(PluginNumber,OldName,NewName,100);
  if (err)
    return FS_FILE_USERABORT;
}

int __stdcall FsGetFile(char* RemoteName,char* LocalName,int CopyFlags,RemoteInfoStruct* ri)
{
  int err;
  BOOL ok,OverWrite,Resume,Move;

  OverWrite=CopyFlags & FS_COPYFLAGS_OVERWRITE; 
  Resume=CopyFlags & FS_COPYFLAGS_RESUME;
  Move=CopyFlags & FS_COPYFLAGS_MOVE;

  if (Resume)
    return FS_FILE_NOTSUPPORTED;

  if (strlen(RemoteName)<pluginrootlen+2 || strlen(RemoteName)<pluginrootlen+2)
    return FS_FILE_NOTFOUND;

  err=ProgressProc(PluginNumber,RemoteName,LocalName,0);
  if (err)
    return FS_FILE_USERABORT;
  if (Move) { 
    if (OverWrite)
      DeleteFile(LocalName);
    ok=DmReceiveFile(LocalName, RemoteName+pluginrootlen);
    DmDeleteFile(RemoteName+pluginrootlen, FALSE);
  } else
    ok=DmReceiveFile(LocalName, RemoteName+pluginrootlen);

  if (ok == XBDM_NOERR ) {
    ProgressProc(PluginNumber,RemoteName,LocalName,100);
    return FS_FILE_OK;
  } else {
    err=GetLastError();
    switch (err) {
case 2:
case 3:
case 4:
case 5:
  return FS_FILE_NOTFOUND;
case ERROR_FILE_EXISTS:
  return FS_FILE_EXISTS;
default:
  return FS_FILE_READERROR;
    }
  }
}


int __stdcall FsPutFile(char* LocalName,char* RemoteName,int CopyFlags)
{
  int err;
  BOOL ok,OverWrite,Resume,Move;

  OverWrite=CopyFlags & FS_COPYFLAGS_OVERWRITE;
  Resume=CopyFlags & FS_COPYFLAGS_RESUME;
  Move=CopyFlags & FS_COPYFLAGS_MOVE;
  if (Resume)
    return FS_FILE_NOTSUPPORTED;

  if (strlen(RemoteName)<pluginrootlen+2 || strlen(RemoteName)<pluginrootlen+2)
    return FS_FILE_NOTFOUND;

  err=ProgressProc(PluginNumber,LocalName,RemoteName,0);
  if (err)
    return FS_FILE_USERABORT;
  if (Move) {
    if (OverWrite)
      DmDeleteFile(RemoteName+pluginrootlen, FALSE);
    ok=DmSendFile(LocalName,RemoteName+pluginrootlen);
    DeleteFile(LocalName);
  } else
    ok=DmSendFile(LocalName,RemoteName+pluginrootlen/*,!OverWrite*/);

  if (ok== XBDM_NOERR ) {
    ProgressProc(PluginNumber,RemoteName,LocalName,100);
    return FS_FILE_OK;
  } else {
    err=GetLastError();
    switch (err) {
case 2:
case 3:
case 4:
case 5:
  return FS_FILE_NOTFOUND;
case ERROR_FILE_EXISTS:
  return FS_FILE_EXISTS;
default:
  return FS_FILE_READERROR;
    }
  }  
}
 
BOOL __stdcall FsDeleteFile(char* RemoteName)
{
  if (strlen(RemoteName)<pluginrootlen+2)
    return false;

  return DmDeleteFile(RemoteName+pluginrootlen, FALSE) == XBDM_NOERR ;	
}

BOOL __stdcall FsRemoveDir(char* RemoteName)
{
  if (strlen(RemoteName)<pluginrootlen+2)
    return false;

  return DmDeleteFile(RemoteName+pluginrootlen, TRUE)== XBDM_NOERR ;	
}

BOOL __stdcall FsSetAttr(char* RemoteName,int NewAttr)
{
  if (strlen(RemoteName)<pluginrootlen+2)
    return false;

  if (NewAttr==0)
    NewAttr=FILE_ATTRIBUTE_NORMAL;
  DM_FILE_ATTRIBUTES attr;
  HRESULT hr = DmGetFileAttributes(RemoteName+pluginrootlen, &attr);

  if (hr != XBDM_NOERR)
    return FALSE;

  attr.Attributes = NewAttr;
  return DmSetFileAttributes(RemoteName+pluginrootlen, &attr);	
}

BOOL __stdcall FsSetTime(char* RemoteName,FILETIME *CreationTime,
                         FILETIME *LastAccessTime,FILETIME *LastWriteTime)
{
  //if (strlen(RemoteName)<pluginrootlen+2)
  //  return false;

  //HANDLE filehandle = CreateFile (RemoteName+pluginrootlen,	
  //  GENERIC_WRITE,          // Open for writing
  //  0,                      // Do not share
  //  NULL,                   // No security
  //  OPEN_EXISTING,          // Existing file only
  //  FILE_ATTRIBUTE_NORMAL,  // Normal file
  //  NULL);

  //if (filehandle==INVALID_HANDLE_VALUE)
  //  return FALSE;

  //BOOL retval=SetFileTime(filehandle,CreationTime,LastAccessTime,LastWriteTime);
  //CloseHandle(filehandle);
  //return retval;
  return FALSE;
}

void __stdcall FsStatusInfo(char* RemoteDir,int InfoStartEnd,int InfoOperation)
{
  // This function may be used to initialize variables and to flush buffers

  /*	char text[MAX_PATH];

  if (InfoStartEnd==FS_STATUS_START)
  strcpy(text,"Start: ");
  else
  strcpy(text,"End: ");

  switch (InfoOperation) {
  case FS_STATUS_OP_LIST:
  strcat(text,"Get directory list");
  break;
  case FS_STATUS_OP_GET_SINGLE:
  strcat(text,"Get single file");
  break;
  case FS_STATUS_OP_GET_MULTI:
  strcat(text,"Get multiple files");
  break;
  case FS_STATUS_OP_PUT_SINGLE:
  strcat(text,"Put single file");
  break;
  case FS_STATUS_OP_PUT_MULTI:
  strcat(text,"Put multiple files");
  break;
  case FS_STATUS_OP_RENMOV_SINGLE:
  strcat(text,"Rename/Move/Remote copy single file");
  break;
  case FS_STATUS_OP_RENMOV_MULTI:
  strcat(text,"Rename/Move/Remote copy multiple files");
  break;
  case FS_STATUS_OP_DELETE:
  strcat(text,"Delete multiple files");
  break;
  case FS_STATUS_OP_ATTRIB:
  strcat(text,"Change attributes of multiple files");
  break;
  case FS_STATUS_OP_MKDIR:
  strcat(text,"Create directory"); 
  break;
  case FS_STATUS_OP_EXEC:
  strcat(text,"Execute file or command line");
  break;
  default:
  strcat(text,"Unknown operation");
  }
  if (InfoOperation != FS_STATUS_OP_LIST)   // avoid recursion due to re-reading!
  MessageBox(0,text,RemoteDir,0);
  */
}

void __stdcall FsGetDefRootName(char* DefRootName,int maxlen)
{
  //char * name = 0;
  //DWORD len;  
  //DmGetNameOfXbox(name, &len, FALSE);

  strlcpy(DefRootName,"XBOX",maxlen);
} 
