//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/**************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/
/*! \file cnv_custompset_anim.cpp
/*!
	implementation file for custom pset animation classes
*/

#include "stdafx.h"
#include "cnv_custompset_anim.h"
#include "../FTKUtil.h"
#include <xsi_sceneitem.h>
#include <xsi_customproperty.h>
#include <Template.h>
#include <CustomPSet.h> 

/**************************************************************************************
CCustomPSetAnimationFromXSI
**************************************************************************************/
CCustomPSetAnimationFromXSI::CCustomPSetAnimationFromXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype)   
{
	m_pAnimationPlotter = NULL;
};

CCustomPSetAnimationFromXSI::~CCustomPSetAnimationFromXSI() {};

CStatus CCustomPSetAnimationFromXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	if((*io_pFTKModel != NULL) && (*io_pFTKModel != in_pFTKParent))
	{
		CSLTemplate *l_pFTKTemplate = *io_pFTKModel;
		CSLCustomPSet **l_ppFTKCustomPSetArray = l_pFTKTemplate->GetCustomPSetList();
		int l_nFTKCustomPSetCount = l_pFTKTemplate->GetCustomPSetCount();

		for (int loop = 0; loop < l_nFTKCustomPSetCount; loop++)
		{
			CSIBCUserData *l_pUserData = l_ppFTKCustomPSetArray[loop]->FindUserData("CREF");

			if(l_pUserData)
			{
				CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
				CustomProperty l_XSICustomPSet = (CustomProperty) *l_pCRef;

				CRefArray l_AnimatedParameters = l_XSICustomPSet.GetAnimatedParameters();

				for(LONG loop2 = 0; loop2 < l_AnimatedParameters.GetCount(); loop2 ++)
				{
					Parameter		l_parameter = l_AnimatedParameters.GetItem(loop2);

					FTKUParameterAnimationFromXSI(l_ppFTKCustomPSetArray[loop], CSLFCurve::SI_PARAMETER, l_parameter, m_pAnimationPlotter);
				}
			}
		}
	}

	return status;
}

wchar_t *CCustomPSetAnimationFromXSI::GetClassID(){return L"CCustomPSetAnimationFromXSI";}


CAnimationPlotter *CCustomPSetAnimationFromXSI::GetAnimationPlotter()
{
	return m_pAnimationPlotter;
}

void CCustomPSetAnimationFromXSI::SetAnimationPlotter(CAnimationPlotter *in_pAnimationPlotter)
{
	m_pAnimationPlotter = in_pAnimationPlotter;
}



/**************************************************************************************
CCustomPSetAnimationToXSI
**************************************************************************************/
CCustomPSetAnimationToXSI::CCustomPSetAnimationToXSI(short in_CryFiletype) : CHierarchyTraverserCallback(in_CryFiletype) {};

CCustomPSetAnimationToXSI::~CCustomPSetAnimationToXSI() {};

CStatus CCustomPSetAnimationToXSI::Execute(CdotXSIConverter *in_pContext, CRef in_XSIParent, CSLTemplate *in_pFTKParent, CHierarchyElementInfo* in_pInfo, CRef *io_pXSIModel, CSLTemplate **io_pFTKModel)
{
	CStatus status = CStatus::OK;

	if(*io_pFTKModel != NULL)
	{
		// we go through all the custom psets of the template
		int loop;				

		CSLTemplate *l_pFTKTemplate = *io_pFTKModel;
		CSLCustomPSet **l_ppFTKCustomPSetArray = l_pFTKTemplate->GetCustomPSetList();
		int l_nFTKCustomPSetCount = l_pFTKTemplate->GetCustomPSetCount();

		for(loop = 0; loop < l_pFTKTemplate->GetCustomPSetCount(); loop ++)
		{
			CSIBCUserData *l_pUserData = l_ppFTKCustomPSetArray[loop]->FindUserData("CREF");

			if(l_pUserData && l_ppFTKCustomPSetArray[loop]->GetFCurveCount())
			{
				CRef *l_pCRef = (CRef*)(l_pUserData->GetData());
				CustomProperty l_XSICustomPSet = (CustomProperty) *l_pCRef;
				CParameterRefArray l_Parameters = l_XSICustomPSet.GetParameters();
				
				CSLFCurve** l_ppFTKFCurve = l_ppFTKCustomPSetArray[loop]->FCurves();
				LONG l_nFTKFCurveCount = l_ppFTKCustomPSetArray[loop]->GetFCurveCount();

				for (LONG loop = 0; loop < l_nFTKFCurveCount; loop++)
				{
					FTKUParameterAnimationToXSI(l_ppFTKFCurve[loop], l_Parameters);
				}
			}
		}
	}

	return status;
}

wchar_t *CCustomPSetAnimationToXSI::GetClassID(){return L"CCustomPSetAnimationToXSI";}

