//***************************************************************************************
//
// File supervisor: Softimage Rendering & Pipeline team
//
// (c) Copyright 2001-2005 Avid Technology, Inc. . All rights reserved.
//
//***************************************************************************************

/****************************************************************************************
THIS CODE IS PUBLISHED AS A SAMPLE ONLY AND IS PROVIDED "AS IS".
IN NO EVENT SHALL SOFTIMAGE, AVID TECHNOLOGY, INC. AND/OR THEIR RESPECTIVE
SUPPLIERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS CODE .

COPYRIGHT NOTICE. Copyright  1999-2005 Avid Technology Inc. . All rights reserved. 

SOFTIMAGE is a registered trademark of Avid Technology Inc. or its subsidiaries 
or divisions. Windows NT is a registered trademark of Microsoft Corp. All other
trademarks contained herein are the property of their respective owners. 
****************************************************************************************/

/*! \file cnv_dotXSI_IO.cpp   
    Implementation file for the dotXSI IO classes
*/
#include "stdafx.h"
#include <stdlib.h>
#include "cnv_dotXSI_IO.h"
#include "plugin_stub.h"
#include <xsi_application.h>
#include <xsi_property.h>
#include <xsi_parameter.h>


/****************************************************************************************
CDotXSI_SetVersion
****************************************************************************************/

CdotXSI_SetVersion::CdotXSI_SetVersion() {};

CdotXSI_SetVersion::~CdotXSI_SetVersion() {};

wchar_t *CdotXSI_SetVersion::GetClassID() {	return L"dotXSI_SetVersion";};

CStatus CdotXSI_SetVersion::Execute(CdotXSIConverter *in_pContext) 
{
	SI_Error	error = SI_SUCCESS;

	LONG Format = in_pContext->exportproperty().GetParameterValue (L"format");

	if ( Format == DOTXSI_FORMAT_5_0 )
	{
		error = in_pContext->ftkscene()->Create(5, 0, FORMAT_TEXT);
	} 
	else if ( Format == DOTXSI_FORMAT_5_0_BINARY )
	{
		error = in_pContext->ftkscene()->Create(5, 0, FORMAT_BINARY);
	} 
	else if ( Format == COLLADA_FORMAT_1_4_1 )
	{
		error = in_pContext->ftkscene()->Create(1, 41, FORMAT_COLLADA);
	}
	else if	( Format == DOTXSI_FORMAT_6_0 )
	{
		error = in_pContext->ftkscene()->Create(6, 0, FORMAT_TEXT);
	}
	else if	( Format == DOTXSI_FORMAT_6_0_BINARY )
	{
		error = in_pContext->ftkscene()->Create(6, 0, FORMAT_BINARY);
	}


	return (error == SI_SUCCESS) ? CStatus::OK : CStatus::Fail;
};

/****************************************************************************************
CDotXSI_Write
****************************************************************************************/

CdotXSI_Write::CdotXSI_Write() {};

CdotXSI_Write::~CdotXSI_Write() {};

wchar_t *CdotXSI_Write::GetClassID() {	return L"dotXSI_Write";};

CStatus CdotXSI_Write::Execute(CdotXSIConverter *in_pContext) 
{
	SI_Error	result = SI_SUCCESS;

	// Here we extract the Filename parameter
	Parameter	Filename = in_pContext->exportproperty().GetParameters().GetItem(L"Filename");

	if(Filename.IsValid())
	{
		// Here's how we extract the value
		CString		strFilePath = Filename.GetValue();

		if (!strFilePath.IsEmpty())
		{
			// then we convert it to an ansi string
			char		strFTKFileName[2048];
			wcstombs(strFTKFileName, strFilePath.GetWideString(), 2048);

			if ( (strlen(strFTKFileName) < 4) || (_stricmp(&(strFTKFileName[strlen(strFTKFileName)-4]),".xsi") != 0) )
			{
				strcat(strFTKFileName, ".xsi");
			}

			// Write
			_SI_CALL(in_pContext->ftkscene()->Write(strFTKFileName), "Failed to write file");

			return (result == SI_SUCCESS) ? CStatus::OK : CStatus::Fail;
		}
		else
		{
			logerror(L"File name not specified");
			return CStatus::Fail;
		}
	}
	
	logerror(L"Could not find a parameter in the property page that has the name \"Filename\"");
	return CStatus::Fail;
};


/****************************************************************************************
CDotXSI_Read
****************************************************************************************/

CdotXSI_Read::CdotXSI_Read() {};

CdotXSI_Read::~CdotXSI_Read() {};

wchar_t *CdotXSI_Read::GetClassID() {	return L"dotXSI_Read";};

CStatus CdotXSI_Read::Execute(CdotXSIConverter *in_pContext) 
{
	SI_Error	result = SI_SUCCESS;

	// Here we extract the Filename parameter
	Parameter	Filename = in_pContext->importproperty().GetParameters().GetItem(L"Filename");

	if(Filename.IsValid())
	{
		// Here's how we extract the value
		CString		strFilePath = Filename.GetValue();

		// then we convert it to an ansi string
		char		strFTKFileName[2048];
		wcstombs(strFTKFileName, strFilePath.GetWideString(), 2048);

		// Open the file
		_SI_CALL(in_pContext->ftkscene()->Open(strFTKFileName), "Failed to open file");

		// Read
		_SI_CALL(in_pContext->ftkscene()->Read(), "Failed to read");

		SI_Long l_FileVersionMajor = 0;
		SI_Long l_FileVersionMinor = 0;

		if (in_pContext->ftkscene()->Parser())
		{
			l_FileVersionMajor = in_pContext->ftkscene()->Parser()->GetdotXSIFileVersionMajor();
			l_FileVersionMinor = in_pContext->ftkscene()->Parser()->GetdotXSIFileVersionMinor();
		}

		if (in_pContext->GetFormat() == COLLADA_FORMAT_1_4_1)
		{
			if (l_FileVersionMajor != 1)
			{
				logerror(L"Invalid COLLADA file. Import aborted.");
				in_pContext->SetCancelPressed(true);
			}
		}
		else
		{
			if (l_FileVersionMajor == 3)
			{
				logerror(L"Invalid file. Import aborted. Note: 3.x dotXSI file must be imported with the 3.x importer.");
				in_pContext->SetCancelPressed(true);
			}
			else if (l_FileVersionMajor < 5)
			{
				logerror(L"Invalid file. Import aborted.");
				in_pContext->SetCancelPressed(true);
			}
		}

		return (result == SI_SUCCESS) ? CStatus::OK : CStatus::Fail;
	}

	logerror(L"Could not find a parameter in the property page that has the name \"Filename\"");
	return CStatus::Fail;
};


